<?php

namespace App\Notifications;

use App\Models\Assignment;
use App\Models\AssignmentSubmission;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class PracticalMarksGraded extends Notification
{
    use Queueable;

    public $assignment;
    public $submission;
    public $marks;
    public $documentPath;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Assignment $assignment, AssignmentSubmission $submission, $marks, $documentPath)
    {
        $this->assignment = $assignment;
        $this->submission = $submission;
        $this->marks = $marks;
        $this->documentPath = $documentPath;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'title' => 'Practical Assessment Graded',
            'message' => "Your practical assessment '{$this->assignment->title}' has been graded. You scored {$this->marks} marks. You can view your results on the assignment page; a completed assessor tool PDF will be available once it has been generated.",
            'assignment_id' => $this->assignment->id,
            'submission_id' => $this->submission->id,
            'marks' => $this->marks,
            'document_path' => $this->documentPath,
            'type' => 'practical_marks_graded',
        ];
    }
}
