<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        // Register ActiveTermService as singleton
        $this->app->singleton(\App\Services\ActiveTermService::class, function ($app) {
            return new \App\Services\ActiveTermService();
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Log slow queries in development (helps identify Supabase performance issues)
        if (config('app.debug') && config('app.env') !== 'production') {
            \DB::listen(function ($query) {
                // Log queries that take longer than 200ms (Supabase network latency)
                if ($query->time > 200) {
                    \Log::warning('Slow Query Detected', [
                        'sql' => $query->sql,
                        'time' => $query->time . 'ms',
                        'bindings' => $query->bindings,
                    ]);
                }
                
                // Log very slow queries (> 1 second) as errors
                if ($query->time > 1000) {
                    \Log::error('Very Slow Query', [
                        'sql' => $query->sql,
                        'time' => $query->time . 'ms',
                        'bindings' => $query->bindings,
                    ]);
                }
            });
        }
    }
}
