<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('poe_evidence', function (Blueprint $table) {
            $table->id();
            $table->foreignId('poe_submission_id')->constrained('poe_submissions')->onDelete('cascade');
            $table->string('file_path');
            $table->enum('file_type', ['document', 'image', 'video', 'other'])->default('document');
            $table->string('file_name');
            $table->string('original_name');
            $table->bigInteger('file_size'); // Size in bytes
            $table->string('mime_type')->nullable();
            $table->json('tags')->nullable(); // Store tags as JSON array
            $table->text('description')->nullable();
            $table->integer('version')->default(1);
            $table->timestamps();
            
            $table->index('poe_submission_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('poe_evidence');
    }
};
