<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reviews', function (Blueprint $table) {
            $table->id();
            $table->foreignId('poe_submission_id')->constrained('poe_submissions')->onDelete('cascade');
            $table->foreignId('reviewer_id')->constrained('users')->onDelete('cascade');
            $table->enum('reviewer_type', ['trainer', 'hod', 'exams_office'])->default('trainer');
            $table->decimal('marks', 5, 2)->nullable(); // Supports up to 999.99
            $table->text('feedback')->nullable();
            $table->enum('status', ['pending', 'approved', 'rejected', 'needs_revision'])->default('pending');
            $table->timestamp('reviewed_at')->nullable();
            $table->timestamps();
            
            $table->index(['poe_submission_id', 'reviewer_type']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reviews');
    }
};
