<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('units', function (Blueprint $table) {
            // Unit classification: core_unit, basic_unit, common_unit
            $table->enum('classification', ['core_unit', 'basic_unit', 'common_unit'])->nullable()->after('department_id');
            
            // Assessment structure configuration (JSON)
            // Format: {"theory": 3, "practical": 3, "oral": 0, "project": 0}
            $table->json('assessment_structure')->nullable()->after('classification');
            
            // Track who configured this and when
            $table->foreignId('configured_by')->nullable()->constrained('users')->onDelete('set null')->after('assessment_structure');
            $table->timestamp('configured_at')->nullable()->after('configured_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('units', function (Blueprint $table) {
            $table->dropForeign(['configured_by']);
            $table->dropColumn(['classification', 'assessment_structure', 'configured_by', 'configured_at']);
        });
    }
};
