<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('practical_evidences', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('unit_id')->constrained('units')->onDelete('cascade');
            $table->foreignId('class_id')->constrained('classes')->onDelete('cascade');
            $table->foreignId('term_id')->constrained('terms')->onDelete('cascade');
            $table->enum('evidence_type', ['video', 'image', 'audio', 'document'])->default('image');
            $table->string('file_path');
            $table->string('file_name');
            $table->string('original_name');
            $table->integer('file_size')->nullable(); // in bytes
            $table->string('mime_type')->nullable();
            $table->string('task_name'); // e.g. "RJ45 Cable Termination"
            $table->text('notes')->nullable();
            $table->enum('status', ['submitted', 'reviewed', 'accepted', 'rejected'])->default('submitted');
            $table->timestamp('uploaded_at')->useCurrent();
            $table->timestamps();
            
            $table->index(['student_id', 'unit_id', 'class_id']);
            $table->index(['unit_id', 'status']);
            $table->index('term_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('practical_evidences');
    }
};
