<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('assignments', function (Blueprint $table) {
            $table->foreignId('class_id')->nullable()->after('trainer_id')->constrained('classes')->onDelete('cascade');
            $table->index(['class_id', 'unit_id', 'is_published']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('assignments', function (Blueprint $table) {
            $table->dropForeign(['class_id']);
            $table->dropIndex(['class_id', 'unit_id', 'is_published']);
            $table->dropColumn('class_id');
        });
    }
};
