<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        // For PostgreSQL, Laravel's enum() creates a CHECK constraint, not a true enum type
        // We need to drop the existing constraint and recreate it with the new value
        try {
            // Drop the existing check constraint
            DB::statement("ALTER TABLE validation_requests DROP CONSTRAINT IF EXISTS validation_requests_status_check");
            
            // Recreate the constraint with the new status value
            DB::statement("ALTER TABLE validation_requests ADD CONSTRAINT validation_requests_status_check CHECK (status IN ('pending', 'approved', 'rejected', 'returned_to_trainer'))");
        } catch (\Exception $e) {
            // If that doesn't work, try finding the actual constraint name
            // PostgreSQL might name it differently
            $constraints = DB::select("
                SELECT constraint_name 
                FROM information_schema.table_constraints 
                WHERE table_name = 'validation_requests' 
                AND constraint_type = 'CHECK' 
                AND constraint_name LIKE '%status%'
            ");
            
            foreach ($constraints as $constraint) {
                DB::statement("ALTER TABLE validation_requests DROP CONSTRAINT IF EXISTS {$constraint->constraint_name}");
            }
            
            // Recreate with new values
            DB::statement("ALTER TABLE validation_requests ADD CONSTRAINT validation_requests_status_check CHECK (status IN ('pending', 'approved', 'rejected', 'returned_to_trainer'))");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        // Revert back to original enum values (without returned_to_trainer)
        try {
            DB::statement("ALTER TABLE validation_requests DROP CONSTRAINT IF EXISTS validation_requests_status_check");
            DB::statement("ALTER TABLE validation_requests ADD CONSTRAINT validation_requests_status_check CHECK (status IN ('pending', 'approved', 'rejected'))");
        } catch (\Exception $e) {
            // Ignore if constraint doesn't exist
        }
    }
};
