<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('trainer_unit_class', function (Blueprint $table) {
            // Add term_id to link trainer-unit-class assignments to a specific term
            if (!Schema::hasColumn('trainer_unit_class', 'term_id')) {
                $table->foreignId('term_id')
                    ->after('class_id')
                    ->constrained('terms')
                    ->onDelete('cascade');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('trainer_unit_class', function (Blueprint $table) {
            if (Schema::hasColumn('trainer_unit_class', 'term_id')) {
                // Drop the foreign key and the column
                $table->dropConstrainedForeignId('term_id');
                // If your Laravel version doesn't support dropConstrainedForeignId,
                // use the following instead:
                // $table->dropForeign(['term_id']);
                // $table->dropColumn('term_id');
            }
        });
    }
};
