<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Remove intake_year column if it exists
        if (Schema::hasColumn('classes', 'intake_year')) {
            Schema::table('classes', function (Blueprint $table) {
                $table->dropColumn('intake_year');
            });
        }
        
        // Ensure term_id exists and is not null
        if (!Schema::hasColumn('classes', 'term_id')) {
            Schema::table('classes', function (Blueprint $table) {
                $table->foreignId('term_id')->after('id')->constrained('terms')->onDelete('cascade');
            });
        } else {
            // Ensure term_id is not nullable using raw SQL
            DB::statement('ALTER TABLE classes ALTER COLUMN term_id SET NOT NULL');
            
            // Ensure foreign key constraint exists
            // Drop constraint if it exists (PostgreSQL)
            try {
                DB::statement('ALTER TABLE classes DROP CONSTRAINT IF EXISTS classes_term_id_foreign');
            } catch (\Exception $e) {
                // Ignore if constraint doesn't exist
            }
            
            // Add foreign key constraint
            DB::statement('ALTER TABLE classes ADD CONSTRAINT classes_term_id_foreign FOREIGN KEY (term_id) REFERENCES terms(id) ON DELETE CASCADE');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('classes', function (Blueprint $table) {
            // Add intake_year back if needed (for rollback)
            if (!Schema::hasColumn('classes', 'intake_year')) {
                $table->integer('intake_year')->nullable()->after('code');
            }
        });
    }
};
