<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop foreign keys first if they exist
        if (Schema::hasTable('practical_evidence_files')) {
            Schema::table('practical_evidence_files', function (Blueprint $table) {
                if (Schema::hasColumn('practical_evidence_files', 'task_id')) {
                    $table->dropForeign(['task_id']);
                }
            });
        }
        
        if (Schema::hasTable('practical_evidence_comments')) {
            Schema::table('practical_evidence_comments', function (Blueprint $table) {
                if (Schema::hasColumn('practical_evidence_comments', 'task_id')) {
                    $table->dropForeign(['task_id']);
                }
            });
        }

        // Drop the existing table if it exists (with CASCADE)
        if (Schema::hasTable('practical_evidence_tasks')) {
            DB::statement('DROP TABLE IF EXISTS practical_evidence_tasks CASCADE');
        }

        Schema::create('practical_evidence_tasks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('unit_id')->constrained('units')->onDelete('cascade');
            $table->foreignId('class_id')->constrained('classes')->onDelete('cascade');
            $table->foreignId('term_id')->constrained('terms')->onDelete('cascade');
            $table->string('task_name'); // e.g., "Motherboard Repair"
            $table->enum('status', ['submitted', 'under_review', 'accepted', 'rejected', 'needs_correction'])->default('submitted');
            $table->text('trainer_comment')->nullable();
            $table->foreignId('reviewed_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('submitted_at')->useCurrent();
            $table->timestamp('reviewed_at')->nullable();
            $table->timestamps();
            
            // Unique constraint: one task per student-unit-class-task_name combination
            $table->unique(['student_id', 'unit_id', 'class_id', 'task_name', 'term_id'], 'unique_task_submission');
            
            // Indexes for performance
            $table->index(['unit_id', 'status']);
            $table->index(['student_id', 'unit_id']);
            $table->index('term_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('practical_evidence_tasks');
    }
};
