@extends('layouts.admin')

@section('title', 'Audit Log Details')
@section('page-title', 'Audit Log Details')

@section('content')
    <div class="mb-6">
        <a href="{{ route('admin.audit-logs.index') }}" class="text-indigo-600 hover:text-indigo-900 flex items-center">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Audit Logs
        </a>
    </div>

    <div class="bg-white shadow-sm rounded-lg overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
            <h3 class="text-lg font-semibold text-gray-900">Audit Log Details</h3>
        </div>
        <div class="px-6 py-4">
            <dl class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <dt class="text-sm font-medium text-gray-500">ID</dt>
                    <dd class="mt-1 text-sm text-gray-900">#{{ $auditLog->id }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Timestamp</dt>
                    <dd class="mt-1 text-sm text-gray-900">
                        {{ $auditLog->created_at->format('F d, Y h:i:s A') }}
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">User</dt>
                    <dd class="mt-1">
                        @if($auditLog->user)
                            <div class="flex items-center">
                                <div class="h-8 w-8 rounded-full bg-indigo-600 flex items-center justify-center mr-2">
                                    <span class="text-white font-semibold text-xs">{{ substr($auditLog->user->name, 0, 1) }}</span>
                                </div>
                                <div>
                                    <div class="text-sm font-medium text-gray-900">{{ $auditLog->user->name }}</div>
                                    <div class="text-xs text-gray-500">{{ $auditLog->user->email }}</div>
                                </div>
                            </div>
                        @else
                            <span class="text-sm text-gray-400">System</span>
                        @endif
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Action</dt>
                    <dd class="mt-1">
                        <span class="px-3 py-1 text-sm font-semibold rounded-full
                            @if(in_array($auditLog->action, ['created', 'approved', 'validated'])) bg-green-100 text-green-800
                            @elseif(in_array($auditLog->action, ['deleted', 'rejected'])) bg-red-100 text-red-800
                            @elseif(in_array($auditLog->action, ['updated', 'modified'])) bg-blue-100 text-blue-800
                            @else bg-gray-100 text-gray-800
                            @endif">
                            {{ ucfirst($auditLog->action) }}
                        </span>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Model Type</dt>
                    <dd class="mt-1 text-sm text-gray-900">
                        {{ $auditLog->model_type ? class_basename($auditLog->model_type) : '-' }}
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Model ID</dt>
                    <dd class="mt-1 text-sm text-gray-900">
                        {{ $auditLog->model_id ?? '-' }}
                        @if($relatedModel)
                            <a href="#" class="ml-2 text-indigo-600 hover:text-indigo-900 text-xs">View Model</a>
                        @endif
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">IP Address</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $auditLog->ip_address ?? '-' }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">User Agent</dt>
                    <dd class="mt-1 text-sm text-gray-500 text-xs break-all">{{ request()->userAgent() ?? '-' }}</dd>
                </div>
                @if($auditLog->description)
                    <div class="md:col-span-2">
                        <dt class="text-sm font-medium text-gray-500 mb-1">Description</dt>
                        <dd class="text-sm text-gray-900 bg-gray-50 p-3 rounded">{{ $auditLog->description }}</dd>
                    </div>
                @endif
            </dl>

            <!-- Changes -->
            @if($auditLog->changes && count($auditLog->changes) > 0)
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <h4 class="text-sm font-semibold text-gray-900 mb-4">Changes</h4>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="space-y-3">
                            @foreach($auditLog->changes as $field => $change)
                                <div class="border-l-4 border-indigo-500 pl-4">
                                    <div class="flex items-center justify-between">
                                        <span class="text-sm font-medium text-gray-900">{{ ucfirst(str_replace('_', ' ', $field)) }}</span>
                                    </div>
                                    @if(is_array($change))
                                        @if(isset($change['old']) && isset($change['new']))
                                            <div class="mt-1 grid grid-cols-2 gap-2 text-xs">
                                                <div>
                                                    <span class="text-red-600 font-medium">Old:</span>
                                                    <span class="text-gray-600 ml-1">{{ is_array($change['old']) ? json_encode($change['old']) : $change['old'] }}</span>
                                                </div>
                                                <div>
                                                    <span class="text-green-600 font-medium">New:</span>
                                                    <span class="text-gray-600 ml-1">{{ is_array($change['new']) ? json_encode($change['new']) : $change['new'] }}</span>
                                                </div>
                                            </div>
                                        @else
                                            <pre class="mt-1 text-xs text-gray-600">{{ json_encode($change, JSON_PRETTY_PRINT) }}</pre>
                                        @endif
                                    @else
                                        <div class="mt-1 text-xs text-gray-600">{{ $change }}</div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endif

            <!-- Related Model Info -->
            @if($relatedModel)
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <h4 class="text-sm font-semibold text-gray-900 mb-4">Related Model</h4>
                    <div class="bg-blue-50 rounded-lg p-4">
                        <p class="text-sm text-gray-700">
                            <strong>Type:</strong> {{ class_basename($auditLog->model_type) }}<br>
                            <strong>ID:</strong> {{ $auditLog->model_id }}<br>
                            <strong>Status:</strong> <span class="text-green-600">Exists</span>
                        </p>
                    </div>
                </div>
            @elseif($auditLog->model_type && $auditLog->model_id)
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <div class="bg-yellow-50 rounded-lg p-4">
                        <p class="text-sm text-yellow-800">
                            <strong>Note:</strong> The related model ({{ class_basename($auditLog->model_type) }} #{{ $auditLog->model_id }}) no longer exists. It may have been deleted.
                        </p>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endsection

