@extends('layouts.admin')

@section('title', 'Level Details')
@section('page-title', 'Level Details')

@section('content')
    <div class="max-w-7xl mx-auto">
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">{{ $level->name }}</h2>
                        <p class="mt-1 text-sm text-gray-600">Code: {{ $level->code }}</p>
                    </div>
                    <a href="{{ route('admin.levels.edit', $level) }}" class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                        Edit Level
                    </a>
                </div>
            </div>

            <div class="px-6 py-4">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Total Classes</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_classes'] }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Active Classes</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['active_classes'] }}</p>
                    </div>
                </div>

                @if($level->description)
                    <div class="mb-6">
                        <h3 class="text-sm font-medium text-gray-700 mb-2">Description</h3>
                        <p class="text-sm text-gray-600">{{ $level->description }}</p>
                    </div>
                @endif
            </div>
        </div>

        @if($level->classes->count() > 0)
            <div class="bg-white shadow rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Classes</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class Name</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Term</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Department</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($level->classes as $class)
                                    <tr>
                                        <td class="px-4 py-3 text-sm text-gray-900">{{ $class->name }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $class->term->name ?? '-' }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $class->department->name ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection

