@extends('layouts.admin')

@section('title', 'Unit Details')
@section('page-title', 'Unit Details')

@section('content')
    <div class="max-w-7xl mx-auto">
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">{{ $unit->name }}</h2>
                        <p class="mt-1 text-sm text-gray-600">Code: {{ $unit->code }} | Department: {{ $unit->department->name ?? 'Not assigned' }}</p>
                    </div>
                    <div class="flex items-center space-x-3">
                        <a href="{{ route('admin.units.edit', $unit) }}" class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                            Edit Unit
                        </a>
                        <a href="{{ route('admin.units.index') }}" class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                            Back to List
                        </a>
                    </div>
                </div>
            </div>

            @if($unit->description)
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-sm font-medium text-gray-700 mb-2">Description</h3>
                    <p class="text-sm text-gray-600">{{ $unit->description }}</p>
                </div>
            @endif
        </div>

        <!-- Assign Unit to Class -->
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">Assign Unit to Class</h3>
                <p class="text-sm text-gray-600 mt-1">One unit can belong to multiple classes</p>
            </div>
            <form action="{{ route('admin.units.assign-class', $unit) }}" method="POST" class="p-6">
                @csrf
                <div class="flex items-end space-x-4">
                    <div class="flex-1">
                        <label for="class_id" class="block text-sm font-medium text-gray-700 mb-1">Select Class</label>
                        <select name="class_id" id="class_id" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">Select a Class</option>
                            @foreach($allClasses as $class)
                                @if(!$unit->classes->contains($class->id))
                                    <option value="{{ $class->id }}">
                                        {{ $class->name }} - {{ $class->department->name ?? '' }} ({{ $class->term->name ?? '' }})
                                    </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <button type="submit" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                        Assign to Class
                    </button>
                </div>
            </form>
        </div>

        <!-- Assign Trainer to Unit -->
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">Assign Trainer to Unit</h3>
                <p class="text-sm text-gray-600 mt-1">Assign trainers from the same department to this unit</p>
            </div>
            <form action="{{ route('admin.units.assign-trainer', $unit) }}" method="POST" class="p-6">
                @csrf
                <div class="flex items-end space-x-4">
                    <div class="flex-1">
                        <label for="trainer_id" class="block text-sm font-medium text-gray-700 mb-1">Select Trainer</label>
                        <select name="trainer_id" id="trainer_id" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">Select a Trainer</option>
                            @foreach($availableTrainers as $trainer)
                                @if(!$unit->trainers->contains($trainer->id))
                                    <option value="{{ $trainer->id }}">
                                        {{ $trainer->name }} ({{ $trainer->email }})
                                    </option>
                                @endif
                            @endforeach
                        </select>
                        @if($availableTrainers->count() === 0)
                            <p class="mt-1 text-xs text-gray-500">No active trainers available in this department.</p>
                        @endif
                    </div>
                    <button type="submit" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700" 
                            {{ $availableTrainers->count() === 0 ? 'disabled' : '' }}>
                        Assign Trainer
                    </button>
                </div>
            </form>
        </div>

        <!-- Assigned Trainers -->
        @if($unit->trainers->count() > 0)
            <div class="bg-white shadow rounded-lg mb-6">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Assigned Trainers ({{ $unit->trainers->count() }})</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Trainer Name</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Email</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Department</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($unit->trainers as $trainer)
                                    <tr>
                                        <td class="px-4 py-3 text-sm text-gray-900">{{ $trainer->name }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $trainer->email }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $trainer->department->name ?? '-' }}</td>
                                        <td class="px-4 py-3 text-sm">
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $trainer->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                                {{ ucfirst($trainer->status) }}
                                            </span>
                                        </td>
                                        <td class="px-4 py-3 text-right text-sm font-medium">
                                            <form action="{{ route('admin.units.remove-trainer', $unit) }}" method="POST" class="inline" onsubmit="return confirm('Remove this trainer from unit?');">
                                                @csrf
                                                <input type="hidden" name="trainer_id" value="{{ $trainer->id }}">
                                                <button type="submit" class="text-red-600 hover:text-red-900">Remove</button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @else
            <div class="bg-white shadow rounded-lg mb-6">
                <div class="px-6 py-4 text-center text-sm text-gray-500">
                    This unit has no assigned trainers yet. Use the form above to assign trainers.
                </div>
            </div>
        @endif

        <!-- Assigned Classes -->
        @if($unit->classes->count() > 0)
            <div class="bg-white shadow rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Assigned Classes ({{ $unit->classes->count() }})</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class Name</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Term</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Department</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Level</th>
                                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($unit->classes as $class)
                                    <tr>
                                        <td class="px-4 py-3 text-sm text-gray-900">{{ $class->name }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $class->term->name ?? '-' }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $class->department->name ?? '-' }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $class->level->name ?? '-' }}</td>
                                        <td class="px-4 py-3 text-right text-sm font-medium">
                                            <form action="{{ route('admin.units.remove-class', $unit) }}" method="POST" class="inline" onsubmit="return confirm('Remove this unit from class?');">
                                                @csrf
                                                <input type="hidden" name="class_id" value="{{ $class->id }}">
                                                <button type="submit" class="text-red-600 hover:text-red-900">Remove</button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @else
            <div class="bg-white shadow rounded-lg">
                <div class="px-6 py-4 text-center text-sm text-gray-500">
                    This unit is not assigned to any classes yet. Use the form above to assign it to a class.
                </div>
            </div>
        @endif
    </div>
@endsection
