@props(['active' => ''])

<!-- Mobile Sidebar - Using Alpine.js for state management -->
<div x-data="{ 
    mobileMenuOpen: false,
    toggleMenu() {
        this.mobileMenuOpen = !this.mobileMenuOpen;
        if (this.mobileMenuOpen) {
            document.body.style.overflow = 'hidden';
        } else {
            document.body.style.overflow = '';
        }
    },
    closeMenu() {
        this.mobileMenuOpen = false;
        document.body.style.overflow = '';
    }
}" 
     x-init="
        // Listen for toggle events from header button
        window.addEventListener('toggle-mobile-menu', () => {
            toggleMenu();
        });
        // Close menu on escape key
        window.addEventListener('keydown', (e) => {
            if (e.key === 'Escape' && mobileMenuOpen) {
                closeMenu();
            }
        });
     "
     class="md:hidden">
    
    <!-- Mobile Sidebar Overlay -->
    <div x-show="mobileMenuOpen" 
         x-cloak
         x-transition:enter="transition-opacity ease-linear duration-200"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition-opacity ease-linear duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         @click="closeMenu()"
         class="fixed inset-0 bg-gray-900 bg-opacity-50 z-40"></div>

    <!-- Mobile Sidebar -->
    <div x-show="mobileMenuOpen"
         x-cloak
         x-transition:enter="transition ease-out duration-300 transform"
         x-transition:enter-start="-translate-x-full"
         x-transition:enter-end="translate-x-0"
         x-transition:leave="transition ease-in duration-300 transform"
         x-transition:leave-start="translate-x-0"
         x-transition:leave-end="-translate-x-full"
         class="fixed inset-y-0 left-0 z-50 w-64 max-w-[85vw] bg-green-800 border-r border-green-900 overflow-y-auto">
        <div class="flex flex-col h-full">
            <!-- Header -->
            <div class="flex items-center justify-between flex-shrink-0 px-4 py-4 sm:py-5 border-b border-green-700">
                <a href="{{ route('student.dashboard') }}" class="text-lg sm:text-xl font-bold text-white hover:text-green-200 truncate">EPOE System</a>
                <button type="button" @click="closeMenu()" class="text-green-200 hover:text-white p-2 -mr-2 min-h-[44px] min-w-[44px] flex items-center justify-center touch-manipulation rounded-lg focus:ring-2 focus:ring-green-400">
                    <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
            
            <!-- Navigation -->
            <nav class="flex-1 px-2 py-4 space-y-1 overflow-y-auto">
                <!-- Dashboard -->
                <a href="{{ route('student.dashboard') }}" 
                   @click="closeMenu()"
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-md min-h-[44px] touch-manipulation {{ request()->routeIs('student.dashboard') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    Dashboard
                </a>

                <!-- Portfolio Evidence -->
                <a href="{{ route('student.submissions.index') }}" 
                   @click="closeMenu()"
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-md min-h-[44px] touch-manipulation {{ request()->routeIs('student.submissions.*') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    Portfolio Evidence
                </a>

                <!-- Upload Practical Evidence -->
                <a href="{{ route('student.submissions.create') }}" 
                   @click="closeMenu()"
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-md min-h-[44px] touch-manipulation {{ request()->routeIs('student.submissions.create') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                    </svg>
                    Upload Evidence
                </a>

                <!-- My Units -->
                <a href="{{ route('student.units.index') }}" 
                   @click="closeMenu()"
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-md min-h-[44px] touch-manipulation {{ request()->routeIs('student.units.*') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    My Units
                </a>

                <!-- My Progress -->
                <a href="{{ route('student.progress.index') }}" 
                   @click="closeMenu()"
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-md min-h-[44px] touch-manipulation {{ request()->routeIs('student.progress.*') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                    My Progress
                </a>

                <!-- Messages -->
                <a href="{{ route('student.messages.index') }}" 
                   @click="closeMenu()"
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-md min-h-[44px] touch-manipulation {{ request()->routeIs('student.messages.*') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                    </svg>
                    Messages
                    @php
                        $unreadCount = auth()->user()->unreadNotifications()->count() + \App\Models\Message::where('receiver_id', auth()->id())->where('is_read', false)->count();
                    @endphp
                    @if($unreadCount > 0)
                        <span class="ml-auto bg-red-600 text-white text-xs font-semibold px-2 py-1 rounded-full">{{ $unreadCount }}</span>
                    @else
                        <span class="ml-auto bg-green-700 text-green-100 text-xs font-semibold px-2 py-1 rounded-full">0</span>
                    @endif
                </a>

                <!-- Profile -->
                <a href="{{ route('student.profile.edit') }}" 
                   @click="closeMenu()"
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-md min-h-[44px] touch-manipulation {{ request()->routeIs('student.profile.*') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A7 7 0 0112 15a7 7 0 016.879 2.804M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                    </svg>
                    Profile
                </a>
            </nav>

            <!-- Bottom Section -->
            <div class="flex-shrink-0 flex border-t border-green-700 p-4">
                <div class="flex-shrink-0 w-full group block">
                    <div class="flex items-center">
                        <div class="h-10 w-10 rounded-full bg-green-700 flex items-center justify-center">
                            <span class="text-white font-semibold text-sm">{{ substr(auth()->user()->name, 0, 1) }}</span>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-medium text-white truncate">{{ auth()->user()->name }}</p>
                            <p class="text-xs text-green-200">Student</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Desktop Sidebar -->
<div class="hidden md:flex md:flex-shrink-0">
    <div class="flex flex-col w-64">
        <div class="flex flex-col flex-grow pt-5 overflow-y-auto bg-green-800 border-r border-green-900">
            <div class="flex items-center flex-shrink-0 px-4 mb-8">
                <a href="{{ route('student.dashboard') }}" class="text-2xl font-bold text-white hover:text-green-200">EPOE System</a>
            </div>
            <div class="mt-5 flex-1 flex flex-col">
                <nav class="flex-1 px-2 space-y-1">
                    <!-- Dashboard -->
                    <a href="{{ route('student.dashboard') }}" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('student.dashboard') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                        </svg>
                        Dashboard
                    </a>

                    <!-- Portfolio Evidence -->
                    <a href="{{ route('student.submissions.index') }}" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('student.submissions.*') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        Portfolio Evidence
                    </a>

                    <!-- Upload Practical Evidence -->
                    <a href="{{ route('student.submissions.create') }}" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('student.submissions.create') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                        Upload Evidence
                    </a>

                    <!-- My Units -->
                    <a href="{{ route('student.units.index') }}" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('student.units.*') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        My Units
                    </a>

                    <!-- My Progress -->
                    <a href="{{ route('student.progress.index') }}" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('student.progress.*') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                        My Progress
                    </a>

                    <!-- Messages -->
                    <a href="{{ route('student.messages.index') }}" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('student.messages.*') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        Messages
                        @php
                            $unreadCount = auth()->user()->unreadNotifications()->count() + \App\Models\Message::where('receiver_id', auth()->id())->where('is_read', false)->count();
                        @endphp
                        @if($unreadCount > 0)
                            <span class="ml-auto bg-red-600 text-white text-xs font-semibold px-2 py-1 rounded-full">{{ $unreadCount }}</span>
                        @else
                            <span class="ml-auto bg-green-700 text-green-100 text-xs font-semibold px-2 py-1 rounded-full">0</span>
                        @endif
                    </a>

                    <!-- Profile -->
                    <a href="{{ route('student.profile.edit') }}" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('student.profile.*') ? 'bg-green-900 text-white' : 'text-green-100 hover:bg-green-700 hover:text-white' }}">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A7 7 0 0112 15a7 7 0 016.879 2.804M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                        Profile
                    </a>
                </nav>

                <!-- Bottom Section -->
                <div class="flex-shrink-0 flex border-t border-green-700 p-4">
                    <div class="flex-shrink-0 w-full group block">
                        <div class="flex items-center">
                            <div class="h-10 w-10 rounded-full bg-green-700 flex items-center justify-center">
                                <span class="text-white font-semibold text-sm">{{ substr(auth()->user()->name, 0, 1) }}</span>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-white">{{ auth()->user()->name }}</p>
                                <p class="text-xs text-green-200">Student</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    [x-cloak] { display: none !important; }
</style>
