@extends('layouts.hod')

@section('title', 'Create Assessor Tool Structure')
@section('page-title', 'Create Assessor Tool Structure')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">Assessor Tool Structure</h1>
                <p class="text-gray-600">Assignment: {{ $assignment->title }}</p>
            </div>
            <a href="{{ route('hod.assignments.show', $assignment) }}" class="text-blue-600 hover:text-blue-800 font-medium">
                ← Back to Assignment
            </a>
        </div>
    </div>

    @if($structure)
        <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded">
            <p class="text-sm text-blue-700">
                <strong>Structure exists.</strong> This structure will be used for <strong>all students</strong> in this assignment. You can update it below or proceed to marking.
                <a href="{{ route('hod.assessor-tool.marking', $assignment) }}" class="ml-2 text-blue-600 hover:text-blue-800 font-medium underline">
                    Go to Marking Interface
                </a>
            </p>
        </div>
    @else
        <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 rounded">
            <p class="text-sm text-yellow-700">
                <strong>Note:</strong> Create the assessor tool structure once. It will be used for <strong>all students</strong> submitting this assignment. You don't need to create it for each student.
            </p>
        </div>
    @endif

    <!-- Tabs -->
    <div class="bg-white rounded-xl shadow-md">
        <div class="border-b border-gray-200">
            <nav class="flex -mb-px" aria-label="Tabs">
                <button onclick="showTab('manual')" id="tab-manual" class="tab-button active px-6 py-3 text-sm font-medium text-blue-600 border-b-2 border-blue-600">
                    Manual Entry
                </button>
                <button onclick="showTab('auto')" id="tab-auto" class="tab-button px-6 py-3 text-sm font-medium text-gray-500 hover:text-gray-700 border-b-2 border-transparent hover:border-gray-300">
                    Auto Parse (Upload Document)
                </button>
            </nav>
        </div>

        <!-- Manual Entry -->
        <div id="panel-manual" class="tab-panel p-6">
            <form action="{{ route('hod.assessor-tool.store-structure', $assignment) }}" method="POST" id="manual-form">
                @csrf
                <input type="hidden" name="parse_method" value="manual">

                <!-- Header Data -->
                <div class="mb-6 p-4 bg-gray-50 rounded-lg">
                    <h3 class="text-sm font-semibold text-gray-900 mb-3">Header Information (Optional)</h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-xs text-gray-600 mb-1">Candidate Name Field Label</label>
                            <input type="text" name="header_data[candidate_label]" value="Candidate's Name & Registration Code" 
                                   class="w-full text-sm rounded-md border-gray-300">
                        </div>
                        <div>
                            <label class="block text-xs text-gray-600 mb-1">Assessor Name Field Label</label>
                            <input type="text" name="header_data[assessor_label]" value="Assessor's Name & Registration Code" 
                                   class="w-full text-sm rounded-md border-gray-300">
                        </div>
                        <div>
                            <label class="block text-xs text-gray-600 mb-1">Venue Field Label</label>
                            <input type="text" name="header_data[venue_label]" value="Venue of Assessment" 
                                   class="w-full text-sm rounded-md border-gray-300">
                        </div>
                        <div>
                            <label class="block text-xs text-gray-600 mb-1">Date Field Label</label>
                            <input type="text" name="header_data[date_label]" value="Date of Assessment" 
                                   class="w-full text-sm rounded-md border-gray-300">
                        </div>
                    </div>
                </div>

                <!-- Structure Items -->
                <div class="mb-4">
                    <div class="flex items-center justify-between mb-3">
                        <h3 class="text-sm font-semibold text-gray-900">Evaluation Items</h3>
                        <div class="flex gap-2">
                            <button type="button" onclick="addSection()" class="text-sm text-blue-600 hover:text-blue-800 font-medium border border-blue-300 px-3 py-1 rounded">
                                + Add Section (TASK)
                            </button>
                            <button type="button" onclick="addItem()" class="text-sm text-green-600 hover:text-green-800 font-medium border border-green-300 px-3 py-1 rounded">
                                + Add Item
                            </button>
                        </div>
                    </div>
                    <div id="items-container" class="space-y-4">
                        @if($structure && isset($structure->structure['sections']))
                            @php
                                // Group items by section
                                $groupedItems = [];
                                foreach($structure->structure['sections'] as $index => $item) {
                                    $section = $item['section'] ?? 'No Section';
                                    if (!isset($groupedItems[$section])) {
                                        $groupedItems[$section] = [];
                                    }
                                    $groupedItems[$section][] = ['index' => $index, 'item' => $item];
                                }
                            @endphp
                            @foreach($groupedItems as $sectionName => $items)
                                @php $sectionId = 'section-' . $loop->index; @endphp
                                <div class="section-group border-2 border-blue-200 rounded-lg p-4 bg-blue-50" data-section-name="{{ $sectionName }}">
                                    <div class="flex items-center justify-between mb-3">
                                        <input type="text" id="section-name-{{ $sectionId }}" value="{{ $sectionName }}" 
                                               class="text-sm font-semibold text-blue-900 bg-transparent border-b-2 border-blue-300 focus:border-blue-600 outline-none px-2 py-1"
                                               onchange="updateSectionName(this, '{{ $sectionId }}')">
                                        <button type="button" onclick="addItemToSection('{{ $sectionName }}', '{{ $sectionId }}')" class="text-xs text-green-600 hover:text-green-800 font-medium border border-green-300 px-2 py-1 rounded">
                                            + Add Item to {{ $sectionName }}
                                        </button>
                                    </div>
                                    <div class="space-y-2" id="section-items-{{ $sectionId }}">
                                        @foreach($items as $itemData)
                                            @php $index = $itemData['index']; $item = $itemData['item']; @endphp
                                            <div class="item-row p-3 bg-white border border-gray-200 rounded" data-index="{{ $index }}">
                                                <div class="grid grid-cols-12 gap-3">
                                                    <input type="hidden" name="structure[{{ $index }}][section]" value="{{ $item['section'] ?? '' }}" id="hidden-section-{{ $index }}">
                                                    <div class="col-span-12 md:col-span-9">
                                                        <label class="block text-xs text-gray-600 mb-1">Item Description *</label>
                                                        <input type="text" name="structure[{{ $index }}][item_description]" 
                                                               value="{{ $item['item_description'] }}"
                                                               required
                                                               placeholder="e.g., Switched on computer and started IDE" 
                                                               class="w-full text-sm rounded-md border-gray-300">
                                                    </div>
                                                    <div class="col-span-12 md:col-span-2">
                                                        <label class="block text-xs text-gray-600 mb-1">Marks Available *</label>
                                                        <input type="number" name="structure[{{ $index }}][marks_available]" 
                                                               value="{{ $item['marks_available'] }}"
                                                               step="0.01" min="0" required
                                                               class="w-full text-sm rounded-md border-gray-300">
                                                    </div>
                                                    <div class="col-span-12 md:col-span-1 flex items-end">
                                                        <button type="button" onclick="removeItem(this)" class="text-red-600 hover:text-red-800">
                                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                            </svg>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <!-- Default empty section -->
                            <div class="section-group border-2 border-blue-200 rounded-lg p-4 bg-blue-50" data-section-name="">
                                <div class="flex items-center justify-between mb-3">
                                    <input type="text" id="section-name-0" placeholder="Section Name (e.g., TASK 1)" 
                                           class="text-sm font-semibold text-blue-900 bg-transparent border-b-2 border-blue-300 focus:border-blue-600 outline-none px-2 py-1"
                                           onchange="updateSectionName(this, 0)">
                                    <button type="button" onclick="addItemToSection('')" class="text-xs text-green-600 hover:text-green-800 font-medium border border-green-300 px-2 py-1 rounded">
                                        + Add Item
                                    </button>
                                </div>
                                <div class="space-y-2" id="section-items-0">
                                    <div class="item-row p-3 bg-white border border-gray-200 rounded" data-index="0">
                                        <div class="grid grid-cols-12 gap-3">
                                            <input type="hidden" name="structure[0][section]" value="" id="hidden-section-0">
                                            <div class="col-span-12 md:col-span-9">
                                                <label class="block text-xs text-gray-600 mb-1">Item Description *</label>
                                                <input type="text" name="structure[0][item_description]" 
                                                       required
                                                       placeholder="e.g., Switched on computer and started IDE" 
                                                       class="w-full text-sm rounded-md border-gray-300">
                                            </div>
                                            <div class="col-span-12 md:col-span-2">
                                                <label class="block text-xs text-gray-600 mb-1">Marks Available *</label>
                                                <input type="number" name="structure[0][marks_available]" 
                                                       step="0.01" min="0" required
                                                       class="w-full text-sm rounded-md border-gray-300">
                                            </div>
                                            <div class="col-span-12 md:col-span-1 flex items-end">
                                                <button type="button" onclick="removeItem(this)" class="text-red-600 hover:text-red-800">
                                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                    </svg>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="flex justify-end gap-3">
                    <a href="{{ route('hod.assignments.show', $assignment) }}" 
                       class="px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                        Cancel
                    </a>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 text-sm font-medium">
                        Save Structure
                    </button>
                </div>
            </form>
        </div>

        <!-- Auto Parse -->
        <div id="panel-auto" class="tab-panel hidden p-6">
            <form action="{{ route('hod.assessor-tool.store-structure', $assignment) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="parse_method" value="auto">

                <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 rounded mb-4">
                    <p class="text-sm text-yellow-700">
                        <strong>Note:</strong> Automatic parsing requires additional packages. 
                        If you encounter errors, please use Manual Entry or install: 
                        <code class="bg-yellow-100 px-1 rounded">composer require phpoffice/phpword smalot/pdfparser</code>
                    </p>
                </div>

                @if($assessorToolFiles && count($assessorToolFiles) > 0)
                    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded mb-4">
                        <p class="text-sm text-blue-700">
                            <strong>Info:</strong> The system will automatically use the assessor tool file uploaded during practical creation.
                        </p>
                        <div class="mt-2">
                            <p class="text-xs text-blue-600 font-semibold">Assessor tool file to be parsed:</p>
                            <ul class="list-disc list-inside text-xs text-blue-600 mt-1">
                                @foreach($assessorToolFiles as $file)
                                    <li>{{ basename($file) }}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                @else
                    <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded mb-4">
                        <p class="text-sm text-red-700">
                            <strong>Error:</strong> No assessor tool file found in this assignment. 
                            Please ensure the assessor tool was uploaded during practical creation.
                            <a href="{{ route('hod.assignments.show', $assignment) }}" class="ml-2 text-red-600 hover:text-red-800 font-medium underline">
                                Go back to assignment
                            </a>
                        </p>
                    </div>
                @endif

                <div class="space-y-4">
                    <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                        <p class="text-sm text-gray-700">
                            <strong>Auto Parsing:</strong> The system will automatically parse the assessor tool file that was uploaded during practical creation. 
                            After parsing, the structure will be saved and you can proceed to mark students.
                        </p>
                        <p class="text-xs text-gray-600 mt-2">
                            <strong>Note:</strong> Once marks are saved for a student, the completed assessor tool with marks will be automatically sent to that specific student.
                        </p>
                    </div>

                    <div class="flex justify-end gap-3">
                        <a href="{{ route('hod.assignments.show', $assignment) }}" 
                           class="px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                            Cancel
                        </a>
                        <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 text-sm font-medium">
                            Parse & Save
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
let itemIndex = {{ $structure && isset($structure->structure['sections']) ? count($structure->structure['sections']) : 1 }};

function showTab(tabName) {
    document.querySelectorAll('.tab-panel').forEach(panel => {
        panel.classList.add('hidden');
    });
    document.querySelectorAll('.tab-button').forEach(button => {
        button.classList.remove('active', 'text-blue-600', 'border-blue-600');
        button.classList.add('text-gray-500', 'border-transparent');
    });
    
    document.getElementById('panel-' + tabName).classList.remove('hidden');
    const activeTab = document.getElementById('tab-' + tabName);
    activeTab.classList.add('active', 'text-blue-600', 'border-blue-600');
    activeTab.classList.remove('text-gray-500', 'border-transparent');
}

function addSection() {
    const container = document.getElementById('items-container');
    const sectionName = prompt('Enter section name (e.g., TASK 1):', 'TASK 1');
    if (!sectionName) return;
    
    const sectionGroup = document.createElement('div');
    sectionGroup.className = 'section-group border-2 border-blue-200 rounded-lg p-4 bg-blue-50';
    sectionGroup.setAttribute('data-section-name', sectionName);
    
    const sectionId = 'section-' + Date.now();
    sectionGroup.innerHTML = `
        <div class="flex items-center justify-between mb-3">
            <input type="text" id="section-name-${sectionId}" value="${sectionName}" 
                   class="text-sm font-semibold text-blue-900 bg-transparent border-b-2 border-blue-300 focus:border-blue-600 outline-none px-2 py-1"
                   onchange="updateSectionName(this, '${sectionId}')">
            <button type="button" onclick="addItemToSection('${sectionName}', '${sectionId}')" class="text-xs text-green-600 hover:text-green-800 font-medium border border-green-300 px-2 py-1 rounded">
                + Add Item to ${sectionName}
            </button>
        </div>
        <div class="space-y-2" id="section-items-${sectionId}">
            ${createItemHTML(itemIndex, sectionName, sectionId)}
        </div>
    `;
    container.appendChild(sectionGroup);
    itemIndex++;
}

function addItemToSection(sectionName, sectionId = null) {
    // If sectionId not provided, find the section group
    let targetSection;
    if (sectionId) {
        targetSection = document.getElementById('section-items-' + sectionId);
    } else {
        // Find section by name
        const sections = document.querySelectorAll('.section-group');
        for (let section of sections) {
            const nameInput = section.querySelector('input[id^="section-name-"]');
            if (nameInput && nameInput.value === sectionName) {
                const sectionIdAttr = nameInput.id.replace('section-name-', '');
                targetSection = document.getElementById('section-items-' + sectionIdAttr);
                sectionId = sectionIdAttr;
                break;
            }
        }
    }
    
    if (!targetSection) {
        // Create new section if not found
        addSection();
        return;
    }
    
    const newItem = document.createElement('div');
    newItem.className = 'item-row p-3 bg-white border border-gray-200 rounded';
    newItem.setAttribute('data-index', itemIndex);
    newItem.innerHTML = createItemHTML(itemIndex, sectionName, sectionId);
    targetSection.appendChild(newItem);
    itemIndex++;
}

function createItemHTML(index, sectionName, sectionId) {
    return `
        <div class="grid grid-cols-12 gap-3">
            <input type="hidden" name="structure[${index}][section]" value="${sectionName}" id="hidden-section-${index}">
            <div class="col-span-12 md:col-span-9">
                <label class="block text-xs text-gray-600 mb-1">Item Description *</label>
                <input type="text" name="structure[${index}][item_description]" 
                       required
                       placeholder="e.g., Switched on computer and started IDE" 
                       class="w-full text-sm rounded-md border-gray-300">
            </div>
            <div class="col-span-12 md:col-span-2">
                <label class="block text-xs text-gray-600 mb-1">Marks Available *</label>
                <input type="number" name="structure[${index}][marks_available]" 
                       step="0.01" min="0" required
                       class="w-full text-sm rounded-md border-gray-300">
            </div>
            <div class="col-span-12 md:col-span-1 flex items-end">
                <button type="button" onclick="removeItem(this)" class="text-red-600 hover:text-red-800">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                    </svg>
                </button>
            </div>
        </div>
    `;
}

function updateSectionName(input, sectionId) {
    const newName = input.value;
    const sectionGroup = input.closest('.section-group');
    sectionGroup.setAttribute('data-section-name', newName);
    
    // Update all hidden inputs in this section
    const items = sectionGroup.querySelectorAll('.item-row');
    items.forEach(item => {
        const hiddenInput = item.querySelector('input[type="hidden"][name*="[section]"]');
        if (hiddenInput) {
            hiddenInput.value = newName;
        }
    });
    
    // Update button text
    const button = sectionGroup.querySelector('button[onclick*="addItemToSection"]');
    if (button) {
        button.textContent = '+ Add Item to ' + newName;
        button.setAttribute('onclick', `addItemToSection('${newName}', '${sectionId}')`);
    }
}

function addItem() {
    // Add item to the first section or create a new section
    const sections = document.querySelectorAll('.section-group');
    if (sections.length > 0) {
        const firstSection = sections[0];
        const nameInput = firstSection.querySelector('input[id^="section-name-"]');
        const sectionName = nameInput ? nameInput.value : '';
        const sectionId = nameInput ? nameInput.id.replace('section-name-', '') : null;
        addItemToSection(sectionName, sectionId);
    } else {
        addSection();
    }
}

function removeItem(button) {
    const itemRow = button.closest('.item-row');
    const sectionItems = itemRow.closest('.section-group').querySelectorAll('.item-row');
    if (sectionItems.length > 1) {
        itemRow.remove();
    } else {
        alert('At least one item is required in this section.');
    }
}
</script>
@endsection

