@extends('layouts.hod')

@section('title', 'Term Units')
@section('page-title', 'Term Units - History')

@section('content')
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Units - {{ $term->name }}</h1>
                <p class="mt-1 text-sm text-gray-600">View all units from this historical term (Department only)</p>
            </div>
            <a href="{{ route('hod.history.show', $term) }}" class="text-purple-600 hover:text-purple-900">Back to Term Details</a>
        </div>
    </div>

    @if($units->isEmpty())
        <div class="bg-white shadow rounded-lg p-8 text-center">
            <h3 class="text-sm font-medium text-gray-900">No Units</h3>
            <p class="mt-1 text-sm text-gray-500">No units found for this term in your department.</p>
        </div>
    @else
        <div class="bg-white shadow rounded-lg overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit Name</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Code</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Department</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($units as $unit)
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">{{ $unit->name }}</td>
                                <td class="px-6 py-4 text-sm text-gray-600">{{ $unit->code }}</td>
                                <td class="px-6 py-4 text-sm text-gray-600">{{ $unit->department->name ?? '-' }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <a href="{{ route('hod.history.print-unit-marks', [$term, $unit->id]) }}" 
                                       target="_blank"
                                       class="inline-flex items-center px-3 py-1 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-purple-600 hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500">
                                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                                        </svg>
                                        Print Marks
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif
@endsection

