@extends('layouts.hod')

@section('title', 'Profile')
@section('page-title', 'My Profile')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-bold text-gray-900">My Profile</h1>
            <a href="{{ route('hod.profile.edit') }}" class="bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition-colors font-medium">
                Edit Profile
            </a>
        </div>
    </div>

    <!-- Profile Information -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Profile Card -->
        <div class="lg:col-span-2 bg-white rounded-xl shadow-md p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Personal Information</h2>
            <dl class="grid grid-cols-1 gap-4">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Full Name</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $user->name }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Email Address</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $user->email }}</dd>
                    @if($user->email_verified_at)
                        <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-green-100 text-green-800 mt-1">
                            Verified
                        </span>
                    @else
                        <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-yellow-100 text-yellow-800 mt-1">
                            Not Verified
                        </span>
                    @endif
                </div>
                @if($user->phone)
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Phone Number</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $user->phone }}</dd>
                    </div>
                @endif
                <div>
                    <dt class="text-sm font-medium text-gray-500">Role</dt>
                    <dd class="mt-1 text-sm text-gray-900">Head of Department</dd>
                </div>
                @if($user->department)
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Department</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $user->department->name }}</dd>
                        @if($user->department->code)
                            <dd class="text-xs text-gray-500">Code: {{ $user->department->code }}</dd>
                        @endif
                    </div>
                @endif
                <div>
                    <dt class="text-sm font-medium text-gray-500">Account Status</dt>
                    <dd class="mt-1">
                        <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium {{ $user->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            {{ ucfirst($user->status) }}
                        </span>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Member Since</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $user->created_at->format('M d, Y') }}</dd>
                </div>
            </dl>
        </div>

        <!-- Department Statistics -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Department Overview</h2>
            <div class="space-y-4">
                <div class="text-center p-4 bg-gray-50 rounded-lg">
                    <p class="text-3xl font-bold text-gray-900">{{ $departmentStats['total_classes'] ?? 0 }}</p>
                    <p class="text-sm text-gray-600 mt-1">Total Classes</p>
                </div>
                <div class="text-center p-4 bg-gray-50 rounded-lg">
                    <p class="text-3xl font-bold text-gray-900">{{ $departmentStats['total_students'] ?? 0 }}</p>
                    <p class="text-sm text-gray-600 mt-1">Total Students</p>
                </div>
                <div class="text-center p-4 bg-gray-50 rounded-lg">
                    <p class="text-3xl font-bold text-gray-900">{{ $departmentStats['total_trainers'] ?? 0 }}</p>
                    <p class="text-sm text-gray-600 mt-1">Total Trainers</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

