@extends('layouts.hod')

@section('title', 'Unit Details')
@section('page-title', 'Unit Details')

@section('content')
<div class="mb-6">
    <a href="{{ request('context') === 'departmental' ? route('hod.units.departmental') : route('hod.units.index') }}" class="text-purple-600 hover:text-purple-900 flex items-center">
        <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
        </svg>
        {{ request('context') === 'departmental' ? 'Back to Departmental Units' : 'Back to Units' }}
    </a>
</div>

<div class="bg-white rounded-xl shadow-md p-6 mb-6">
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900 mb-2">{{ $unit->name }}</h1>
            @if($unit->code)
                <p class="text-sm text-gray-600">Code: {{ $unit->code }}</p>
            @endif
            @if($unit->description)
                <p class="text-sm text-gray-700 mt-2">{{ $unit->description }}</p>
            @endif
            <p class="text-sm text-gray-500 mt-2">Department: {{ $unit->department->name ?? 'N/A' }}</p>
            @if($unit->classification)
                <p class="text-sm text-gray-500 mt-1">
                    Classification: <span class="font-medium">{{ ucfirst(str_replace('_', ' ', $unit->classification)) }}</span>
                </p>
            @endif
            @if($unit->configured_at)
                <p class="text-xs text-gray-400 mt-1">
                    Configured: {{ $unit->configured_at->format('M d, Y') }}
                    @if($unit->configuredBy)
                        by {{ $unit->configuredBy->name }}
                    @endif
                </p>
            @endif
        </div>
        <div class="flex flex-wrap gap-2">
            <button type="button" onclick="document.getElementById('assignmentModal').classList.remove('hidden')" class="inline-flex items-center px-4 py-2 bg-purple-600 text-white text-sm font-medium rounded-md shadow-sm hover:bg-purple-700">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                Create Assignment
            </button>
            {{-- Configure Unit and Print Marks only in Departmental Units context (where settings happen) --}}
            @if(request('context') === 'departmental')
                <a href="{{ route('hod.units.configure', $unit) }}?context=departmental" 
                   class="inline-flex items-center px-4 py-2 bg-gray-600 text-white text-sm font-medium rounded-md shadow-sm hover:bg-gray-700">
                    {{ $unit->isConfigured() ? 'Update Configuration' : 'Configure Unit' }}
                </a>
                <a href="{{ route('hod.marks.print-unit', $unit) }}" 
                   target="_blank"
                   class="inline-flex items-center px-4 py-2 bg-green-600 text-white text-sm font-medium rounded-md shadow-sm hover:bg-green-700">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                    </svg>
                    Print Marks Summary
                </a>
            @endif
        </div>
    </div>
</div>

<!-- Tabs -->
<div class="bg-white rounded-xl shadow-md">
    <div class="border-b border-gray-200">
        <nav class="flex -mb-px">
            <button onclick="showTab('assignments')" class="tab-button py-4 px-6 text-sm font-medium border-b-2 border-purple-500 text-purple-600">
                Assignments
            </button>
            <button onclick="showTab('submissions')" class="tab-button py-4 px-6 text-sm font-medium border-b-2 border-transparent text-gray-500 hover:text-gray-700">
                Submissions
            </button>
            <button onclick="showTab('classes')" class="tab-button py-4 px-6 text-sm font-medium border-b-2 border-transparent text-gray-500 hover:text-gray-700">
                Classes
            </button>
            <button onclick="showTab('trainers')" class="tab-button py-4 px-6 text-sm font-medium border-b-2 border-transparent text-gray-500 hover:text-gray-700">
                Trainers
            </button>
        </nav>
    </div>

    <!-- Assignments Tab -->
    <div id="assignments-tab" class="tab-content p-6">
        @if(!$activeTerm)
            <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No Active Term</h3>
                <p class="mt-1 text-sm text-gray-500">No assignments available. Please activate a term to view assignments.</p>
            </div>
        @elseif($assignments->count() > 0)
            <div class="space-y-4">
                @foreach($assignments as $assignment)
                    <div class="border border-gray-200 rounded-lg p-4">
                        <div class="flex flex-wrap items-center justify-between gap-3">
                            <div class="min-w-0 flex-1">
                                <h3 class="font-semibold text-gray-900">{{ $assignment->title }}</h3>
                                <p class="text-sm text-gray-600 mt-1">By: {{ $assignment->trainer->name }}</p>
                                <div class="flex flex-wrap gap-4 mt-2 text-xs text-gray-500">
                                    <span>Type: {{ ucfirst($assignment->type) }}</span>
                                    <span>Marks: {{ $assignment->total_marks ?? '—' }}</span>
                                    @if($assignment->due_date)
                                        <span>Due: {{ $assignment->due_date->format('M d, Y') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="flex flex-wrap items-center gap-2">
                                <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $assignment->is_published ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                    {{ $assignment->is_published ? 'Published' : 'Draft' }}
                                </span>
                                @if($assignment->trainer_id === auth()->id())
                                    @php $ctx = request('context') === 'departmental' ? '?context=departmental' : ''; @endphp
                                    <a href="{{ route('hod.assignments.show', $assignment) }}{{ $ctx }}" 
                                       class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-blue-700 bg-blue-50 rounded-md hover:bg-blue-100 transition-colors"
                                       title="View Assignment">
                                        <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                        </svg>
                                        View
                                    </a>
                                    <a href="{{ route('hod.assignments.edit', $assignment) }}{{ $ctx }}" 
                                       class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-gray-700 bg-gray-50 rounded-md hover:bg-gray-100 transition-colors"
                                       title="Edit Assignment">
                                        <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                        </svg>
                                        Edit
                                    </a>
                                    <form action="{{ route('hod.assignments.destroy', $assignment) }}" 
                                          method="POST" 
                                          onsubmit="return confirm('Are you sure you want to delete this assignment?');"
                                          class="inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" 
                                                class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-red-700 bg-red-50 rounded-md hover:bg-red-100 transition-colors"
                                                title="Delete Assignment">
                                            <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                            </svg>
                                            Delete
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="mt-4">
                {{ $assignments->links() }}
            </div>
        @else
            <p class="text-sm text-gray-500 text-center py-8">No assignments found.</p>
        @endif
    </div>

    <!-- Submissions Tab -->
    <div id="submissions-tab" class="tab-content p-6 hidden">
        @if(!$activeTerm)
            <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No Active Term</h3>
                <p class="mt-1 text-sm text-gray-500">No submissions available. Please activate a term to view submissions.</p>
            </div>
        @elseif($submissions->count() > 0)
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Submitted</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($submissions as $submission)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $submission->student->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $submission->schoolClass->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $submission->getStatusBadgeClasses() }}">
                                        {{ ucfirst(str_replace('_', ' ', $submission->status)) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $submission->submitted_at ? $submission->submitted_at->format('M d, Y') : '-' }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-4">
                {{ $submissions->links() }}
            </div>
        @else
            <p class="text-sm text-gray-500 text-center py-8">No submissions found.</p>
        @endif
    </div>

    <!-- Classes Tab -->
    <div id="classes-tab" class="tab-content p-6 hidden">
        @if(!$activeTerm)
            <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No Active Term</h3>
                <p class="mt-1 text-sm text-gray-500">No classes available. Please activate a term to view classes.</p>
            </div>
        @elseif($assignedClasses->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                @foreach($assignedClasses as $class)
                    <div class="border border-gray-200 rounded-lg p-4">
                        <h3 class="font-semibold text-gray-900">{{ $class->name }}</h3>
                        @if($class->code)
                            <p class="text-sm text-gray-500">{{ $class->code }}</p>
                        @endif
                        @if($class->term)
                            <p class="text-xs text-gray-400 mt-1">Term: {{ $class->term->name }}</p>
                        @endif
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-sm text-gray-500 text-center py-8">No classes assigned to this unit.</p>
        @endif
    </div>

    <!-- Trainers Tab -->
    <div id="trainers-tab" class="tab-content p-6 hidden">
        @if(!$activeTerm)
            <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No Active Term</h3>
                <p class="mt-1 text-sm text-gray-500">No trainers available. Please activate a term to view trainers.</p>
            </div>
        @elseif($trainers->count() > 0)
            <div class="space-y-3">
                @foreach($trainers as $trainer)
                    <div class="border border-gray-200 rounded-lg p-4">
                        <h3 class="font-semibold text-gray-900">{{ $trainer->name }}</h3>
                        <p class="text-sm text-gray-500">{{ $trainer->email }}</p>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-sm text-gray-500 text-center py-8">No trainers assigned to this unit.</p>
        @endif
    </div>
</div>

<!-- Create Assignment Modal -->
<div id="assignmentModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-semibold text-gray-900">Create Assignment / Exam / Practical / Project</h3>
            <button type="button" onclick="document.getElementById('assignmentModal').classList.add('hidden')" class="text-gray-400 hover:text-gray-600">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>

        @if(!$activeTerm || $assignedClasses->isEmpty())
            <div class="py-6 text-center">
                <svg class="mx-auto h-12 w-12 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                </svg>
                <p class="mt-3 text-sm font-medium text-gray-900">You cannot create assignments yet</p>
                <p class="mt-1 text-sm text-gray-600 max-w-sm mx-auto">
                    @if(!$activeTerm)
                        No active term is set. Please contact your administrator to activate a term.
                    @else
                        No classes are assigned to this unit. Assign this unit to at least one class under <a href="{{ route('hod.units.departmental') }}" class="text-purple-600 hover:text-purple-800 font-medium">Departmental Units</a> or Unit Allocations first.
                    @endif
                </p>
                <div class="mt-4">
                    <button type="button" onclick="document.getElementById('assignmentModal').classList.add('hidden')" class="px-4 py-2 bg-gray-200 text-gray-800 rounded-md hover:bg-gray-300 text-sm font-medium">Close</button>
                </div>
            </div>
        @else
        <form id="assignmentForm" action="{{ route('hod.units.assignments.store', $unit) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Title *</label>
                    <input type="text" name="title" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Type *</label>
                    <select name="type" id="assignment_type" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500" onchange="togglePracticalFields()">
                        <option value="assignment">Assignment</option>
                        <option value="exam">Exam</option>
                        <option value="practical">Practical</option>
                        <option value="project">Project</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Class *</label>
                    <select name="class_id" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                        <option value="">Select a class</option>
                        @foreach($assignedClasses as $class)
                            <option value="{{ $class->id }}">{{ $class->name }}@if($class->code) ({{ $class->code }})@endif</option>
                        @endforeach
                    </select>
                    <p class="mt-1 text-xs text-gray-500">Select the class this assignment is for</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Description</label>
                    <textarea name="description" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"></textarea>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Total Marks</label>
                        <input type="number" name="total_marks" min="0" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Due Date</label>
                        <input type="datetime-local" name="due_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Start Date</label>
                    <input type="datetime-local" name="start_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Instructions</label>
                    <textarea name="instructions" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"></textarea>
                </div>
                <div id="regular_attachments">
                    <label class="block text-sm font-medium text-gray-700">Attachments</label>
                    <input type="file" name="attachments[]" multiple class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                    <p class="mt-1 text-xs text-gray-500">You can select multiple files (max 10MB each)</p>
                </div>
                <div id="practical_tools" class="hidden space-y-4">
                    <div class="p-4 bg-purple-50 border border-purple-200 rounded-lg">
                        <p class="text-sm font-medium text-purple-900 mb-3">Practical Assessment Tools</p>
                        <p class="text-xs text-purple-700 mb-4">For practical assessments, you must upload both the Candidate Tool (for students) and Assessor Tool (marking guide).</p>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Candidate Tool <span class="text-red-500">*</span></label>
                            <input type="file" name="candidate_tool[]" id="candidate_tool_input" multiple class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700" disabled>
                        </div>
                        <div class="mt-3">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Assessor Tool <span class="text-red-500">*</span></label>
                            <input type="file" name="assessor_tool[]" id="assessor_tool_input" multiple class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700" disabled>
                        </div>
                    </div>
                </div>
                <div class="flex items-center">
                    <input type="checkbox" name="is_published" value="1" id="is_published" class="h-4 w-4 text-purple-600 focus:ring-purple-500 border-gray-300 rounded">
                    <label for="is_published" class="ml-2 block text-sm text-gray-900">Publish immediately (visible to students)</label>
                </div>
            </div>
            <div class="mt-6 flex justify-end gap-3">
                <button type="button" onclick="document.getElementById('assignmentModal').classList.add('hidden')" class="px-4 py-2 bg-gray-200 text-gray-800 rounded-md hover:bg-gray-300">Cancel</button>
                <button type="submit" id="createAssignmentBtn" class="px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700">Create Assignment</button>
            </div>
        </form>
        @endif
    </div>
</div>

@push('scripts')
<script>
function showTab(tabName) {
    document.querySelectorAll('.tab-content').forEach(tab => tab.classList.add('hidden'));
    document.querySelectorAll('.tab-button').forEach(btn => {
        btn.classList.remove('border-purple-500', 'text-purple-600');
        btn.classList.add('border-transparent', 'text-gray-500');
    });
    var el = document.getElementById(tabName + '-tab');
    if (el) el.classList.remove('hidden');
    if (typeof event !== 'undefined' && event.target) {
        event.target.classList.remove('border-transparent', 'text-gray-500');
        event.target.classList.add('border-purple-500', 'text-purple-600');
    }
}

function togglePracticalFields() {
    var assignmentType = document.getElementById('assignment_type');
    if (!assignmentType) return;
    var type = assignmentType.value;
    var regularAttachments = document.getElementById('regular_attachments');
    var practicalTools = document.getElementById('practical_tools');
    var candidateInput = document.getElementById('candidate_tool_input');
    var assessorInput = document.getElementById('assessor_tool_input');
    if (type === 'practical') {
        if (regularAttachments) regularAttachments.classList.add('hidden');
        if (practicalTools) practicalTools.classList.remove('hidden');
        if (candidateInput) { candidateInput.removeAttribute('disabled'); candidateInput.setAttribute('required', 'required'); }
        if (assessorInput) { assessorInput.removeAttribute('disabled'); assessorInput.setAttribute('required', 'required'); }
    } else {
        if (regularAttachments) regularAttachments.classList.remove('hidden');
        if (practicalTools) practicalTools.classList.add('hidden');
        if (candidateInput) { candidateInput.setAttribute('disabled', 'disabled'); candidateInput.removeAttribute('required'); if (candidateInput.value) candidateInput.value = ''; }
        if (assessorInput) { assessorInput.setAttribute('disabled', 'disabled'); assessorInput.removeAttribute('required'); if (assessorInput.value) assessorInput.value = ''; }
    }
}

document.addEventListener('DOMContentLoaded', function() {
    togglePracticalFields();
    var form = document.getElementById('assignmentForm');
    if (form) {
        form.addEventListener('submit', function(e) {
            var type = document.getElementById('assignment_type') && document.getElementById('assignment_type').value;
            if (type === 'practical') {
                var c = document.getElementById('candidate_tool_input');
                var a = document.getElementById('assessor_tool_input');
                if (c && (!c.files || c.files.length === 0)) { e.preventDefault(); alert('Please upload at least one Candidate Tool file for practical assessments.'); return false; }
                if (a && (!a.files || a.files.length === 0)) { e.preventDefault(); alert('Please upload at least one Assessor Tool file for practical assessments.'); return false; }
            }
            var btn = document.getElementById('createAssignmentBtn');
            if (btn) { btn.disabled = true; btn.textContent = 'Creating...'; }
            return true;
        });
    }
});
</script>
@endpush
@endsection

