@extends('layouts.student')

@section('title', 'Messages & Notifications')
@section('page-title', 'Messages & Notifications')

@section('content')
    <div class="mb-4 sm:mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div class="min-w-0">
            <h1 class="text-xl sm:text-2xl font-bold text-gray-900">Messages & Notifications</h1>
            <p class="mt-1 text-sm text-gray-600">View your notifications and messages</p>
        </div>
        <div class="flex flex-wrap gap-2">
            @if($unreadNotifications > 0)
                <form action="{{ route('student.messages.mark-all-notifications-read') }}" method="POST" class="inline">
                    @csrf
                    <button type="submit" class="px-4 py-2.5 min-h-[44px] text-xs sm:text-sm font-medium text-white bg-indigo-600 rounded hover:bg-indigo-700 touch-manipulation">
                        Mark All Notifications Read
                    </button>
                </form>
            @endif
            @if($unreadMessages > 0)
                <form action="{{ route('student.messages.mark-all-messages-read') }}" method="POST" class="inline">
                    @csrf
                    <button type="submit" class="px-4 py-2.5 min-h-[44px] text-xs sm:text-sm font-medium text-white bg-indigo-600 rounded hover:bg-indigo-700 touch-manipulation">
                        Mark All Messages Read
                    </button>
                </form>
            @endif
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="grid grid-cols-2 gap-3 sm:gap-4 mb-4 sm:mb-6">
        <div class="bg-white rounded-lg shadow p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Notifications</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">{{ $notifications->total() }}</p>
                </div>
                @if($unreadNotifications > 0)
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                        {{ $unreadNotifications }} unread
                    </span>
                @endif
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Messages</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">{{ $messages->total() }}</p>
                </div>
                @if($unreadMessages > 0)
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                        {{ $unreadMessages }} unread
                    </span>
                @endif
            </div>
        </div>
    </div>

    <!-- Tabs -->
    <div class="bg-white rounded-lg shadow-sm mb-4 sm:mb-6 overflow-hidden">
        <div class="border-b border-gray-200 overflow-x-auto" style="-webkit-overflow-scrolling: touch;">
            <nav class="flex -mb-px min-w-max sm:min-w-0" aria-label="Tabs">
                <button type="button" onclick="showTab('notifications')" id="tab-notifications" class="tab-button active px-4 sm:px-6 py-3 min-h-[44px] text-sm font-medium border-b-2 border-indigo-500 text-indigo-600 touch-manipulation whitespace-nowrap">
                    Notifications
                    @if($unreadNotifications > 0)
                        <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-red-100 text-red-800">{{ $unreadNotifications }}</span>
                    @endif
                </button>
                <button type="button" onclick="showTab('messages')" id="tab-messages" class="tab-button px-4 sm:px-6 py-3 min-h-[44px] text-sm font-medium border-b-2 border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 touch-manipulation whitespace-nowrap">
                    Messages
                    @if($unreadMessages > 0)
                        <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-red-100 text-red-800">{{ $unreadMessages }}</span>
                    @endif
                </button>
            </nav>
        </div>

        <!-- Notifications Tab -->
        <div id="notifications-content" class="tab-content">
            @if($notifications->count() > 0)
                <div class="divide-y divide-gray-200">
                    @foreach($notifications as $notification)
                        <div class="p-4 hover:bg-gray-50 {{ !$notification->read_at ? 'bg-blue-50' : '' }}">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <div class="flex items-center space-x-2 flex-wrap">
                                        @if(!$notification->read_at)
                                            <span class="h-2 w-2 bg-blue-600 rounded-full flex-shrink-0"></span>
                                        @endif
                                        <p class="text-sm font-medium text-gray-900">
                                            {{ $notification->data['title'] ?? 'Notification' }}
                                        </p>
                                        @php
                                            $sender = $notificationSenders[$notification->id] ?? null;
                                        @endphp
                                        @if($sender)
                                            <span class="text-xs text-gray-500">
                                                from 
                                                <span class="font-medium text-gray-700">{{ $sender->name }}</span>
                                                @if($sender->role)
                                                    <span class="px-1.5 py-0.5 text-xs rounded bg-gray-100 text-gray-600 ml-1">
                                                        {{ ucfirst(str_replace('_', ' ', $sender->role)) }}
                                                    </span>
                                                @endif
                                            </span>
                                        @endif
                                    </div>
                                    <p class="mt-1 text-sm text-gray-600">
                                        {{ $notification->data['message'] ?? $notification->data['body'] ?? 'No message content' }}
                                    </p>
                                    <p class="mt-1 text-xs text-gray-500">
                                        {{ $notification->created_at->diffForHumans() }}
                                    </p>
                                </div>
                                <div class="ml-4 flex items-center space-x-2">
                                    <a href="{{ route('student.messages.show-notification', $notification->id) }}" class="text-indigo-600 hover:text-indigo-900 text-sm">
                                        View
                                    </a>
                                    @if(!$notification->read_at)
                                        <form action="{{ route('student.messages.mark-notification-read', $notification->id) }}" method="POST" class="inline">
                                            @csrf
                                            <button type="submit" class="text-gray-500 hover:text-gray-700 text-sm">
                                                Mark Read
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="px-6 py-4 border-t border-gray-200">
                    {{ $notifications->links() }}
                </div>
            @else
                <div class="p-12 text-center">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No notifications</h3>
                    <p class="mt-1 text-sm text-gray-500">You don't have any notifications yet.</p>
                </div>
            @endif
        </div>

        <!-- Messages Tab -->
        <div id="messages-content" class="tab-content hidden">
            @if($messages->count() > 0)
                <div class="divide-y divide-gray-200">
                    @foreach($messages as $message)
                        <div class="p-4 hover:bg-gray-50 {{ !$message->is_read ? 'bg-blue-50' : '' }}">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <div class="flex items-center space-x-2">
                                        @if(!$message->is_read)
                                            <span class="h-2 w-2 bg-blue-600 rounded-full"></span>
                                        @endif
                                        <p class="text-sm font-medium text-gray-900">
                                            {{ $message->subject }}
                                        </p>
                                        <span class="text-xs text-gray-500">
                                            from {{ $message->sender->name }}
                                            @if($message->sender->role)
                                                <span class="px-1.5 py-0.5 text-xs rounded bg-gray-100 text-gray-600">
                                                    {{ ucfirst($message->sender->role) }}
                                                </span>
                                            @endif
                                        </span>
                                    </div>
                                    <p class="mt-1 text-sm text-gray-600 line-clamp-2">
                                        {{ Str::limit($message->body, 150) }}
                                    </p>
                                    <p class="mt-1 text-xs text-gray-500">
                                        {{ $message->created_at->diffForHumans() }}
                                    </p>
                                </div>
                                <div class="mt-2 sm:mt-0 sm:ml-4 flex flex-wrap items-center gap-2">
                                    <a href="{{ route('student.messages.show-message', $message->id) }}" class="inline-flex items-center min-h-[44px] sm:min-h-0 text-indigo-600 hover:text-indigo-900 text-sm touch-manipulation">
                                        View
                                    </a>
                                    @if(!$message->is_read)
                                        <form action="{{ route('student.messages.mark-message-read', $message->id) }}" method="POST" class="inline">
                                            @csrf
                                            <button type="submit" class="text-gray-500 hover:text-gray-700 text-sm touch-manipulation py-2 sm:py-0">
                                                Mark Read
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="px-6 py-4 border-t border-gray-200">
                    {{ $messages->links() }}
                </div>
            @else
                <div class="p-12 text-center">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No messages</h3>
                    <p class="mt-1 text-sm text-gray-500">You don't have any messages yet.</p>
                </div>
            @endif
        </div>
    </div>

    <script>
        function showTab(tab) {
            // Hide all tab contents
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.add('hidden');
            });
            
            // Remove active class from all tabs
            document.querySelectorAll('.tab-button').forEach(button => {
                button.classList.remove('active', 'border-indigo-500', 'text-indigo-600');
                button.classList.add('border-transparent', 'text-gray-500');
            });
            
            // Show selected tab content
            document.getElementById(tab + '-content').classList.remove('hidden');
            
            // Add active class to selected tab
            const selectedTab = document.getElementById('tab-' + tab);
            selectedTab.classList.add('active', 'border-indigo-500', 'text-indigo-600');
            selectedTab.classList.remove('border-transparent', 'text-gray-500');
        }
    </script>
@endsection

