@extends('layouts.student')

@section('title', 'Message Details')
@section('page-title', 'Message Details')

@section('content')
    <div class="mb-4 sm:mb-6">
        <a href="{{ route('student.messages.index') }}" class="text-indigo-600 hover:text-indigo-900 flex items-center touch-manipulation">
            <svg class="h-5 w-5 mr-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Messages
        </a>
    </div>

    <div class="bg-white shadow-sm rounded-lg overflow-hidden">
        <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-gray-50">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-semibold text-gray-900">{{ $message->subject }}</h3>
                @if($message->is_read)
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                        Read
                    </span>
                @else
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                        Unread
                    </span>
                @endif
            </div>
        </div>
        <div class="px-6 py-4">
            <div class="mb-4">
                <p class="text-sm text-gray-500 mb-1">From</p>
                <div class="flex items-center space-x-2">
                    <div class="h-8 w-8 rounded-full bg-indigo-600 flex items-center justify-center">
                        <span class="text-white font-semibold text-xs">{{ substr($message->sender->name, 0, 1) }}</span>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-900">{{ $message->sender->name }}</p>
                        <p class="text-xs text-gray-500">
                            {{ $message->sender->email }}
                            @if($message->sender->role)
                                • {{ ucfirst($message->sender->role) }}
                            @endif
                            @if($message->sender->department)
                                • {{ $message->sender->department->name }}
                            @endif
                        </p>
                    </div>
                </div>
            </div>
            <div class="mb-4">
                <p class="text-sm text-gray-500 mb-1">Received</p>
                <p class="text-sm text-gray-900">{{ $message->created_at->format('F d, Y h:i A') }}</p>
            </div>
            @if($message->read_at)
                <div class="mb-4">
                    <p class="text-sm text-gray-500 mb-1">Read</p>
                    <p class="text-sm text-gray-900">{{ $message->read_at->format('F d, Y h:i A') }}</p>
                </div>
            @endif
            <div class="pt-4 border-t border-gray-200">
                <p class="text-sm text-gray-500 mb-2">Message</p>
                <div class="bg-gray-50 p-4 rounded-lg">
                    <p class="text-sm text-gray-900 whitespace-pre-wrap">{{ $message->body }}</p>
                </div>
            </div>
        </div>
    </div>
@endsection

