@extends('layouts.student')

@section('title', 'Notification Details')
@section('page-title', 'Notification Details')

@section('content')
    <div class="mb-4 sm:mb-6">
        <a href="{{ route('student.messages.index') }}" class="text-indigo-600 hover:text-indigo-900 flex items-center touch-manipulation">
            <svg class="h-5 w-5 mr-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Messages
        </a>
    </div>

    <div class="bg-white shadow-sm rounded-lg overflow-hidden">
        <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-gray-50">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-semibold text-gray-900">
                    {{ $notification->data['title'] ?? 'Notification' }}
                </h3>
                @if($notification->read_at)
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                        Read
                    </span>
                @else
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                        Unread
                    </span>
                @endif
            </div>
        </div>
        <div class="px-6 py-4">
            @if($sender)
                <div class="mb-4">
                    <p class="text-sm text-gray-500 mb-1">From</p>
                    <div class="flex items-center gap-2">
                        <p class="text-sm font-medium text-gray-900">{{ $sender->name }}</p>
                        @if($sender->role)
                            <span class="px-2 py-1 text-xs font-medium rounded bg-gray-100 text-gray-700">
                                {{ ucfirst(str_replace('_', ' ', $sender->role)) }}
                            </span>
                        @endif
                        @if($sender->department)
                            <span class="text-xs text-gray-500">({{ $sender->department->name }})</span>
                        @endif
                    </div>
                </div>
            @endif
            <div class="mb-4">
                <p class="text-sm text-gray-500 mb-1">Received</p>
                <p class="text-sm text-gray-900">{{ $notification->created_at->format('F d, Y h:i A') }}</p>
            </div>
            <div class="mb-4">
                <p class="text-sm text-gray-500 mb-1">Type</p>
                <p class="text-sm text-gray-900">{{ $notification->type }}</p>
            </div>
            <div class="pt-4 border-t border-gray-200">
                <p class="text-sm text-gray-500 mb-2">Message</p>
                <div class="bg-gray-50 p-4 rounded-lg">
                    <p class="text-sm text-gray-900 whitespace-pre-wrap">
                        {{ $notification->data['message'] ?? $notification->data['body'] ?? 'No message content available.' }}
                    </p>
                </div>
            </div>
            @if(isset($notification->data['action_url']))
                <div class="mt-4">
                    <a href="{{ $notification->data['action_url'] }}" class="inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] bg-indigo-600 text-white rounded-md hover:bg-indigo-700 touch-manipulation">
                        View Related Item
                    </a>
                </div>
            @endif
        </div>
    </div>
@endsection

