@extends('layouts.trainer')

@section('title', 'Unit Marks - ' . $unit->name)

@section('content')
@php
    $validationErrorMessage = session('validation_push_error');
    $validationErrorsList = session('validation_errors', []);
    $showValidationErrorDialog = !empty($validationErrorMessage) || !empty($validationErrorsList);
@endphp

{{-- Error dialog when push to validation fails (unit config / readiness) --}}
@if($showValidationErrorDialog)
<div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true"
     x-data="{ open: true }"
     x-show="open"
     x-cloak
     x-transition:enter="ease-out duration-300"
     x-transition:enter-start="opacity-0"
     x-transition:enter-end="opacity-100"
     x-transition:leave="ease-in duration-200"
     x-transition:leave-start="opacity-100"
     x-transition:leave-end="opacity-0">
    <div class="flex min-h-screen items-center justify-center p-4 pointer-events-none">
        <div class="relative bg-white rounded-lg shadow-xl max-w-md w-full p-6 pointer-events-auto"
             x-show="open"
             x-transition:enter="ease-out duration-300"
             x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
             @click.away="open = false">
            <div class="flex items-start gap-3">
                <div class="shrink-0 w-10 h-10 rounded-full bg-red-100 flex items-center justify-center">
                    <svg class="w-5 h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                    </svg>
                </div>
                <div class="flex-1 min-w-0">
                    <h3 class="text-lg font-semibold text-gray-900" id="modal-title">Cannot push to validation</h3>
                    <p class="mt-2 text-sm text-gray-600">{{ $validationErrorMessage ?? 'The unit does not meet the requirements for validation.' }}</p>
                    @if(!empty($validationErrorsList))
                        <ul class="mt-3 list-disc list-inside text-sm text-red-700 space-y-1">
                            @foreach($validationErrorsList as $err)
                                <li>{{ is_string($err) ? $err : json_encode($err) }}</li>
                            @endforeach
                        </ul>
                    @endif
                    <p class="mt-3 text-xs text-gray-500">Ensure the unit is configured and all required assessments are completed with marks for all students.</p>
                </div>
            </div>
            <div class="mt-6 flex justify-end">
                <button type="button" @click="open = false" class="inline-flex justify-center rounded-md border border-gray-300 bg-white px-4 py-2 text-sm font-medium text-gray-700 shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                    Close
                </button>
            </div>
        </div>
    </div>
</div>
@endif

    <div class="mb-4 sm:mb-6">
        <a href="{{ route('trainer.marks.index') }}" class="text-blue-600 hover:text-blue-900 flex items-center mb-4 touch-manipulation">
            <svg class="h-5 w-5 mr-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Units
        </a>
        <h1 class="text-xl sm:text-2xl font-bold text-gray-900 break-words">{{ $unit->name }}</h1>
        <p class="mt-1 text-sm text-gray-600">Code: {{ $unit->code }}</p>
    </div>

    @if($activeTerm)
        <div class="mb-4 sm:mb-6">
            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                Active Term: {{ $activeTerm->name }}
            </span>
        </div>
    @endif

    <!-- Unit Info Card -->
    <div class="bg-white rounded-lg shadow mb-4 sm:mb-6 p-4 sm:p-6">
        <div class="flex flex-col sm:flex-row sm:items-start sm:justify-between gap-4">
            <div class="min-w-0 flex-1">
                <h2 class="text-base sm:text-lg font-semibold text-gray-900 mb-2">Unit Information</h2>
                <div class="space-y-1 text-sm text-gray-600">
                    <p><strong>Department:</strong> {{ $unit->department->name ?? 'N/A' }}</p>
                    @if($unit->classification)
                        <p><strong>Classification:</strong> <span class="font-medium">{{ ucfirst(str_replace('_', ' ', $unit->classification)) }}</span></p>
                    @endif
                    @if($unit->isConfigured())
                        <p><strong>Assessment Structure:</strong>
                            @php
                                $structure = $unit->getAssessmentStructure();
                            @endphp
                            Theory: {{ $structure['theory'] }}, 
                            Practical: {{ $structure['practical'] }}, 
                            Oral: {{ $structure['oral'] }}, 
                            Project: {{ $structure['project'] }}
                        </p>
                    @endif
                    @if($unit->configured_at)
                        <p class="text-xs text-gray-500">
                            Configured: {{ $unit->configured_at->format('M d, Y') }}
                            @if($unit->configuredBy)
                                by {{ $unit->configuredBy->name }}
                            @endif
                        </p>
                    @endif
                </div>
            </div>
            <div class="flex-shrink-0">
                <a href="{{ route('trainer.marks.print-unit', ['unit' => $unit->id, 'class_id' => optional($selectedClass)->id]) }}" 
                   class="inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] bg-blue-600 text-white text-sm font-medium rounded-md shadow-sm hover:bg-blue-700 touch-manipulation w-full sm:w-auto">
                    <svg class="w-4 h-4 mr-2 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                    </svg>
                    @if($selectedClass)
                        Print Marks for {{ $selectedClass->code ?? $selectedClass->name }}
                    @else
                        Print All Marks
                    @endif
                </a>
            </div>
        </div>
    </div>

    <!-- Class Selection -->
    <div class="bg-white rounded-lg shadow mb-4 sm:mb-6 p-4 sm:p-6">
        <h2 class="text-base sm:text-lg font-semibold text-gray-900 mb-4">Select Class</h2>
        <form method="GET" action="{{ route('trainer.marks.show-unit', $unit) }}" class="flex flex-col sm:flex-row gap-3">
            <div class="flex-1 w-full min-w-0">
                <label class="block text-sm font-medium text-gray-700 mb-1">Class</label>
                <select name="class" class="w-full rounded-md border-gray-300 shadow-sm text-base">
                    <option value="">Select a class...</option>
                    @foreach($classes as $class)
                        <option value="{{ $class->id }}" {{ request('class') == $class->id ? 'selected' : '' }}>
                            {{ $class->name }} ({{ $class->code }})
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="flex items-end">
                <button type="submit" class="w-full sm:w-auto bg-blue-600 text-white px-4 py-2.5 min-h-[44px] rounded-md hover:bg-blue-700 touch-manipulation">Load</button>
            </div>
        </form>
    </div>

    @if($selectedClass)
        <!-- Validation Readiness Panel -->
        <div class="bg-gradient-to-r from-purple-50 to-blue-50 rounded-lg p-4 sm:p-6 border border-purple-200 mb-4 sm:mb-6">
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3 mb-4">
                <div class="min-w-0">
                    <h3 class="text-base sm:text-lg font-semibold text-gray-900">Validation Readiness</h3>
                    <p class="text-sm text-gray-600 break-words">
                        Class: <strong>{{ $selectedClass->name }}</strong>
                        <span class="hidden sm:inline"> | </span><br class="sm:hidden">
                        Unit: <strong>{{ $unit->name }}</strong>
                        @if(isset($validationReadiness['unit_classification']))
                            <span class="hidden sm:inline"> | </span><br class="sm:hidden">
                            Category: <strong>{{ ucfirst(str_replace('_', ' ', $validationReadiness['unit_classification'])) }}</strong>
                        @endif
                    </p>
                </div>
                @if(isset($pendingValidationRequest) && $pendingValidationRequest)
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-amber-100 text-amber-800">
                        Under validation
                    </span>
                @elseif(isset($validationReadiness['ready']) && $validationReadiness['ready'])
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                        ✓ Ready for Validation
                    </span>
                @else
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-100 text-red-800">
                        ✗ Not Ready
                    </span>
                @endif
            </div>

            @if(isset($validationReadiness['assessment_status']))
                <div class="mb-4">
                    <h4 class="text-sm font-medium text-gray-700 mb-2">Assessment Status:</h4>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                        @foreach(['theory', 'practical', 'oral', 'project'] as $type)
                            @php
                                $status = $validationReadiness['assessment_status'][$type] ?? ['required' => 0, 'completed' => 0, 'status' => 'complete'];
                            @endphp
                            <div class="bg-white rounded p-3 border {{ $status['status'] === 'complete' ? 'border-green-300' : 'border-red-300' }}">
                                <div class="text-xs font-medium text-gray-600 uppercase mb-1">{{ ucfirst($type) }}</div>
                                <div class="text-lg font-semibold {{ $status['status'] === 'complete' ? 'text-green-700' : 'text-red-700' }}">
                                    {{ $status['completed'] }} / {{ $status['required'] }}
                                    @if($status['status'] === 'complete')
                                        <span class="text-green-600">✓</span>
                                    @else
                                        <span class="text-red-600">✗</span>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            @if(isset($validationReadiness['errors']) && count($validationReadiness['errors']) > 0)
                <div class="mb-4 bg-red-50 border border-red-200 rounded p-4">
                    <h4 class="text-sm font-medium text-red-800 mb-2">Issues Found:</h4>
                    <ul class="text-sm text-red-700 list-disc list-inside space-y-1">
                        @foreach($validationReadiness['errors'] as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if(isset($validationReadiness['unit_not_configured']) && $validationReadiness['unit_not_configured'])
                <div class="mb-4 bg-yellow-50 border border-yellow-200 rounded p-4">
                    <p class="text-sm text-yellow-800">
                        ⚠ This unit has not been configured by the HOD. Please contact your HOD to configure the assessment structure.
                    </p>
                </div>
            @endif

            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 pt-4 border-t border-purple-200">
                @if(isset($pendingValidationRequest) && $pendingValidationRequest)
                    <p class="text-sm text-gray-600 order-2 sm:order-1">
                        This class and unit are currently in the validation portal. You can cancel the request to remove them.
                    </p>
                    <form method="POST" action="{{ route('trainer.marks.validation-requests.cancel', $pendingValidationRequest) }}" class="inline order-1 sm:order-2" onsubmit="return confirm('Cancel this validation request? The unit will be removed from the validation portal.');">
                        @csrf
                        <button type="submit" class="w-full sm:w-auto inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] bg-amber-600 text-white text-sm font-medium rounded-md shadow-sm hover:bg-amber-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-amber-500 touch-manipulation">
                            Cancel validation request
                        </button>
                    </form>
                @else
                    <p class="text-sm text-gray-600 order-2 sm:order-1">
                        Pushing to validation will lock all marks for this class and unit.
                    </p>
                    <form method="POST" action="{{ route('trainer.marks.push-to-validation', ['class' => $selectedClass, 'unit' => $unit]) }}" class="order-1 sm:order-2">
                        @csrf
                        <button type="submit"
                                @if(!isset($validationReadiness['ready']) || !$validationReadiness['ready'])
                                    disabled
                                    class="w-full sm:w-auto inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] bg-gray-400 text-white text-sm font-medium rounded-md shadow-sm cursor-not-allowed"
                                @else
                                    class="w-full sm:w-auto inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] bg-purple-600 text-white text-sm font-medium rounded-md shadow-sm hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500 touch-manipulation"
                                @endif>
                            Push Class to Validation
                        </button>
                    </form>
                @endif
            </div>
        </div>
    @endif

    <!-- Marks Printing Section -->
    <div class="bg-white rounded-lg shadow p-4 sm:p-6">
        <h2 class="text-base sm:text-lg font-semibold text-gray-900 mb-4">Print Marks</h2>
        
        @if($assignments->count() > 0)
            <div class="space-y-3">
                <p class="text-sm text-gray-600 mb-4">Print marks for individual assessments:</p>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                    @foreach($assignments as $assignment)
                        <div class="border border-gray-200 rounded-lg p-4 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-2">
                            <div class="min-w-0">
                                <h4 class="text-sm font-medium text-gray-900 break-words">{{ $assignment->title }}</h4>
                                <p class="text-xs text-gray-500">{{ ucfirst($assignment->type) }}</p>
                            </div>
                            <a href="{{ route('trainer.marks.print-assignment', $assignment) }}{{ $selectedClass ? '?class=' . $selectedClass->id : '' }}" 
                               class="self-start sm:self-center inline-flex items-center px-3 py-2 min-h-[44px] text-blue-600 hover:text-blue-900 text-sm font-medium touch-manipulation">
                                Print
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        @else
            <p class="text-sm text-gray-500">No published assignments found for this unit.</p>
        @endif
    </div>
@endsection



