@extends('layouts.trainer')

@section('title', 'Send Notifications')
@section('page-title', 'Send Notifications')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900 mb-2">Send Notifications</h1>
            <p class="text-gray-600">Send notifications to students in your assigned classes</p>
        </div>
    </div>

    <!-- Tabs -->
    <div class="bg-white rounded-xl shadow-md">
        <div class="border-b border-gray-200">
            <nav class="flex -mb-px" aria-label="Tabs">
                <button onclick="showTab('individual')" id="tab-individual" class="tab-button active px-6 py-3 text-sm font-medium text-blue-600 border-b-2 border-blue-600">
                    Individual
                </button>
                <button onclick="showTab('class')" id="tab-class" class="tab-button px-6 py-3 text-sm font-medium text-gray-500 hover:text-gray-700 border-b-2 border-transparent hover:border-gray-300">
                    To Class
                </button>
                <button onclick="showTab('all')" id="tab-all" class="tab-button px-6 py-3 text-sm font-medium text-gray-500 hover:text-gray-700 border-b-2 border-transparent hover:border-gray-300">
                    All Students
                </button>
            </nav>
        </div>

        <!-- Individual Notification -->
        <div id="panel-individual" class="tab-panel p-6">
            <form action="{{ route('trainer.notifications.individual') }}" method="POST">
                @csrf
                <div class="space-y-4">
                    <div>
                        <label for="student_id" class="block text-sm font-medium text-gray-700 mb-1">Student <span class="text-red-500">*</span></label>
                        <select name="student_id" id="student_id" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="">Select Student</option>
                            @foreach($students as $student)
                                <option value="{{ $student->id }}">
                                    {{ $student->name }} 
                                    @if($student->admission_number)
                                        ({{ $student->admission_number }})
                                    @endif
                                    - {{ $student->email }}
                                </option>
                            @endforeach
                        </select>
                        @if($students->isEmpty())
                            <p class="mt-1 text-sm text-gray-500">No students found in your assigned classes.</p>
                        @endif
                    </div>
                    <div>
                        <label for="title_individual" class="block text-sm font-medium text-gray-700 mb-1">Title <span class="text-red-500">*</span></label>
                        <input type="text" name="title" id="title_individual" required
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                               placeholder="Notification title">
                    </div>
                    <div>
                        <label for="message_individual" class="block text-sm font-medium text-gray-700 mb-1">Message <span class="text-red-500">*</span></label>
                        <textarea name="message" id="message_individual" rows="5" required
                                  class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                  placeholder="Enter your message..."></textarea>
                    </div>
                    <div class="flex justify-end">
                        <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors font-medium">
                            Send Notification
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Class Notification -->
        <div id="panel-class" class="tab-panel hidden p-6">
            <form action="{{ route('trainer.notifications.class') }}" method="POST">
                @csrf
                <div class="space-y-4">
                    <div>
                        <label for="class_id" class="block text-sm font-medium text-gray-700 mb-1">Class <span class="text-red-500">*</span></label>
                        <select name="class_id" id="class_id" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="">Select Class</option>
                            @foreach($classes as $class)
                                <option value="{{ $class->id }}">{{ $class->name }} ({{ $class->code }})</option>
                            @endforeach
                        </select>
                        @if($classes->isEmpty())
                            <p class="mt-1 text-sm text-gray-500">No classes found for the active term.</p>
                        @endif
                    </div>
                    <div>
                        <label for="title_class" class="block text-sm font-medium text-gray-700 mb-1">Title <span class="text-red-500">*</span></label>
                        <input type="text" name="title" id="title_class" required
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                               placeholder="Notification title">
                    </div>
                    <div>
                        <label for="message_class" class="block text-sm font-medium text-gray-700 mb-1">Message <span class="text-red-500">*</span></label>
                        <textarea name="message" id="message_class" rows="5" required
                                  class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                  placeholder="Enter your message..."></textarea>
                    </div>
                    <div class="flex justify-end">
                        <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors font-medium">
                            Send to Class
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- All Students Notification -->
        <div id="panel-all" class="tab-panel hidden p-6">
            <form action="{{ route('trainer.notifications.all') }}" method="POST">
                @csrf
                <div class="space-y-4">
                    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded">
                        <p class="text-sm text-blue-700">
                            <strong>Note:</strong> This will send a notification to all students enrolled in your assigned classes.
                        </p>
                    </div>
                    <div>
                        <label for="title_all" class="block text-sm font-medium text-gray-700 mb-1">Title <span class="text-red-500">*</span></label>
                        <input type="text" name="title" id="title_all" required
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                               placeholder="Notification title">
                    </div>
                    <div>
                        <label for="message_all" class="block text-sm font-medium text-gray-700 mb-1">Message <span class="text-red-500">*</span></label>
                        <textarea name="message" id="message_all" rows="5" required
                                  class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                  placeholder="Enter your message..."></textarea>
                    </div>
                    <div class="flex justify-end">
                        <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors font-medium">
                            Send to All Students
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showTab(tabName) {
    // Hide all panels
    document.querySelectorAll('.tab-panel').forEach(panel => {
        panel.classList.add('hidden');
    });
    
    // Remove active class from all tabs
    document.querySelectorAll('.tab-button').forEach(button => {
        button.classList.remove('active', 'text-blue-600', 'border-blue-600');
        button.classList.add('text-gray-500', 'border-transparent');
    });
    
    // Show selected panel
    document.getElementById('panel-' + tabName).classList.remove('hidden');
    
    // Add active class to selected tab
    const activeTab = document.getElementById('tab-' + tabName);
    activeTab.classList.add('active', 'text-blue-600', 'border-blue-600');
    activeTab.classList.remove('text-gray-500', 'border-transparent');
}
</script>
@endsection

