<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document not available</title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: rgba(0, 0, 0, 0.4);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .dialog {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.2);
            max-width: 420px;
            width: 100%;
            overflow: hidden;
        }
        .dialog-icon {
            padding: 24px 24px 0;
            text-align: center;
        }
        .dialog-icon svg {
            width: 56px;
            height: 56px;
            color: #f59e0b;
        }
        .dialog-title {
            padding: 16px 24px 0;
            font-size: 1.25rem;
            font-weight: 600;
            color: #111;
            text-align: center;
        }
        .dialog-message {
            padding: 12px 24px 24px;
            font-size: 0.9375rem;
            color: #4b5563;
            line-height: 1.5;
            text-align: center;
        }
        .dialog-actions {
            padding: 0 24px 24px;
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 10px 16px;
            font-size: 0.9375rem;
            font-weight: 500;
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            border: none;
            transition: background 0.15s;
        }
        .btn-primary {
            background: #4f46e5;
            color: #fff;
        }
        .btn-primary:hover {
            background: #4338ca;
        }
        .btn-secondary {
            background: #f3f4f6;
            color: #374151;
        }
        .btn-secondary:hover {
            background: #e5e7eb;
        }
    </style>
</head>
<body>
    <div class="dialog" role="dialog" aria-labelledby="dialog-title" aria-modal="true">
        <div class="dialog-icon">
            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
            </svg>
        </div>
        <h2 id="dialog-title" class="dialog-title">{{ $title }}</h2>
        <p class="dialog-message">{{ $message }}</p>
        <div class="dialog-actions">
            <button type="button" class="btn btn-primary" onclick="window.close();">
                Close window
            </button>
            <a href="{{ $backUrl }}" class="btn btn-secondary">
                Back to portfolio
            </a>
        </div>
    </div>
</body>
</html>
