@extends('layouts.validator')

@section('title', 'Validate Unit - ' . $validationRequest->unit->name)

@section('content')
<div class="mb-6">
    <a href="{{ route('validator.validation-requests.index') }}" class="text-indigo-600 hover:text-indigo-900 flex items-center mb-4">
        <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
        </svg>
        Back to Units
    </a>
    <h1 class="text-2xl font-bold text-gray-900">Validate Unit</h1>
    <p class="mt-1 text-sm text-gray-600">{{ $validationRequest->schoolClass->name }} - {{ $validationRequest->unit->name }}</p>
</div>

<!-- Unit Information Summary -->
<div class="bg-white rounded-lg shadow mb-6 p-6 border-l-4 border-indigo-500">
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div>
            <h3 class="text-sm font-medium text-gray-600 mb-1">Class</h3>
            <p class="text-lg font-semibold text-gray-900">{{ $validationRequest->schoolClass->name }}</p>
            <p class="text-sm text-gray-600">Code: {{ $validationRequest->schoolClass->code }}</p>
        </div>
        <div>
            <h3 class="text-sm font-medium text-gray-600 mb-1">Unit</h3>
            <p class="text-lg font-semibold text-gray-900">{{ $validationRequest->unit->name }}</p>
            <p class="text-sm text-gray-600">Code: {{ $validationRequest->unit->code }}</p>
            @if($validationRequest->unit->classification)
                <span class="inline-block mt-2 px-2 py-1 text-xs font-medium rounded-full 
                    @if($validationRequest->unit->classification === 'core_unit') bg-purple-100 text-purple-800
                    @elseif($validationRequest->unit->classification === 'basic_unit') bg-blue-100 text-blue-800
                    @else bg-gray-100 text-gray-800
                    @endif">
                    {{ ucfirst(str_replace('_', ' ', $validationRequest->unit->classification)) }}
                </span>
            @endif
        </div>
        <div>
            <h3 class="text-sm font-medium text-gray-600 mb-1">Submitted By</h3>
            <p class="text-lg font-semibold text-gray-900">{{ $validationRequest->submitter->name }}</p>
            <p class="text-sm text-gray-600">{{ $validationRequest->submitted_at->format('M d, Y H:i') }}</p>
        </div>
    </div>
</div>

<!-- Unit summary marks preview -->
<div class="bg-white rounded-lg shadow mb-6 p-6 border-l-4 border-indigo-500">
    <h2 class="text-lg font-semibold text-gray-900 mb-2">Unit Summary Marks</h2>
    <p class="text-sm text-gray-600 mb-4">Preview and print the unit marks list for this class.</p>
    <a href="{{ route('validator.validation-requests.print-marks', ['class' => $validationRequest->schoolClass->id, 'unit' => $validationRequest->unit->id]) }}"
       target="_blank"
       rel="noopener"
       class="inline-flex items-center px-4 py-2 rounded-md border border-indigo-600 text-sm font-medium text-indigo-700 bg-white hover:bg-indigo-50">
        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
        </svg>
        Preview / Print unit marks
    </a>
</div>

<!-- Student Marks Table -->
<div class="bg-white rounded-lg shadow mb-6 overflow-hidden">
    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
        <h2 class="text-lg font-semibold text-gray-900">Student Marks & Validation</h2>
        <p class="text-sm text-gray-600 mt-1">{{ $students->count() }} student(s)</p>
    </div>
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Admission No</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Trainer Marks</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Evidence</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Validator Decision</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Comment</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach($students as $student)
                    @php
                        $studentData = $marksData[$student->id] ?? null;
                        $validation = $studentData['validation'] ?? null;
                        $evidenceCount = $evidenceCounts[$student->id] ?? 0;
                    @endphp
                    <tr class="hover:bg-gray-50" id="student-row-{{ $student->id }}">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900">{{ $student->name }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                            {{ $student->admission_number }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            @if($studentData)
                                <div class="text-sm font-medium text-gray-900">
                                    {{ number_format($studentData['percentage'], 1) }}%
                                </div>
                                <div class="text-xs text-gray-500">
                                    ({{ $studentData['total'] }}/{{ $studentData['max'] }})
                                </div>
                            @else
                                <span class="text-gray-400">-</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            @if($evidenceCount > 0)
                                <a href="{{ route('validator.validation-requests.portfolio.student', ['validationRequest' => $validationRequest->id, 'student' => $student->id]) }}"
                                   class="inline-flex items-center px-3 py-1 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-xs font-medium">
                                    View Portfolio ({{ $evidenceCount }})
                                </a>
                            @else
                                <span class="text-gray-400">No evidence</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($validation)
                                <span class="px-2 py-1 text-xs font-medium rounded-full
                                    @if($validation->decision === 'approved') bg-green-100 text-green-800
                                    @elseif($validation->decision === 'modified') bg-blue-100 text-blue-800
                                    @elseif($validation->decision === 'rejected') bg-red-100 text-red-800
                                    @else bg-yellow-100 text-yellow-800
                                    @endif">
                                    {{ ucfirst($validation->decision) }}
                                </span>
                            @else
                                <span class="px-2 py-1 text-xs font-medium rounded-full bg-gray-100 text-gray-800">Pending</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600 max-w-xs truncate">
                            {{ $validation->validator_comment ?? '-' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <button onclick="openValidationModal({{ $student->id }}, {{ $studentData['percentage'] ?? 0 }}, '{{ $validation->decision ?? 'pending' }}', '{{ addslashes($validation->validator_comment ?? '') }}', {{ $validation->adjusted_marks ?? 'null' }})" 
                                    class="text-indigo-600 hover:text-indigo-900 font-medium">
                                Validate
                            </button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<!-- Final Unit Validation -->
@if($validationRequest->status === 'pending')
<div class="bg-white rounded-lg shadow p-6">
    <h2 class="text-lg font-semibold text-gray-900 mb-4">Final Unit Validation</h2>
    <form method="POST" action="{{ route('validator.validation-requests.validate', $validationRequest) }}" onsubmit="return confirm('Are you sure you want to finalize this unit validation?');">
        @csrf
        <div class="space-y-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Final Decision <span class="text-red-500">*</span></label>
                <select name="status" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">Select decision...</option>
                    <option value="approved">Approve Unit</option>
                    <option value="rejected">Reject Unit</option>
                    <option value="returned_to_trainer">Return to Trainer</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Comments</label>
                <textarea name="validation_comment" rows="4" 
                          placeholder="Enter your validation comments..."
                          class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"></textarea>
            </div>
            <div class="flex items-center justify-end gap-3 pt-4 border-t border-gray-200">
                <a href="{{ route('validator.validation-requests.index') }}" 
                   class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">
                    Cancel
                </a>
                <button type="submit" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                    Finalize Validation
                </button>
            </div>
        </div>
    </form>
</div>
@else
<div class="bg-white rounded-lg shadow p-6">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-900">Validation Status</h2>
        <span class="px-3 py-1 text-sm font-medium rounded-full
            @if($validationRequest->status === 'approved') bg-green-100 text-green-800
            @elseif($validationRequest->status === 'rejected') bg-red-100 text-red-800
            @else bg-blue-100 text-blue-800
            @endif">
            {{ ucfirst(str_replace('_', ' ', $validationRequest->status)) }}
        </span>
    </div>
    @if($validationRequest->validation_comment)
        <div class="mt-4 p-4 bg-gray-50 rounded-lg">
            <p class="text-sm font-medium text-gray-700 mb-2">Validator Comment:</p>
            <p class="text-sm text-gray-600">{{ $validationRequest->validation_comment }}</p>
        </div>
    @endif
    @if($validationRequest->validator)
        <p class="mt-4 text-sm text-gray-600">
            Validated by: <strong>{{ $validationRequest->validator->name }}</strong> 
            on {{ $validationRequest->validated_at->format('M d, Y H:i') }}
        </p>
    @endif
</div>
@endif

<!-- Evidence Viewing Modal -->
<div id="evidenceModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-4/5 lg:w-3/4 shadow-lg rounded-md bg-white max-h-[90vh] overflow-y-auto">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-medium text-gray-900">Evidence Files</h3>
            <button onclick="closeEvidenceModal()" class="text-gray-400 hover:text-gray-600">
                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <div id="evidenceContent">
            <div class="text-center py-8">
                <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-indigo-600"></div>
                <p class="mt-2 text-sm text-gray-600">Loading evidence...</p>
            </div>
        </div>
    </div>
</div>

<!-- Validation Modal -->
<div id="validationModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-1/2 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Validate Student Marks</h3>
            <form id="validationForm" method="POST">
                @csrf
                <input type="hidden" name="student_id" id="modal_student_id">
                
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Current Marks</label>
                        <p class="text-lg font-semibold text-gray-900"><span id="modal_current_marks">0</span>%</p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Decision <span class="text-red-500">*</span></label>
                        <select name="decision" id="modal_decision" required 
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                onchange="toggleAdjustedMarks()">
                            <option value="approved">✓ Approve</option>
                            <option value="modified">✎ Adjust Marks</option>
                            <option value="rejected">✗ Reject</option>
                        </select>
                    </div>
                    
                    <div id="adjusted_marks_container" class="hidden">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Adjusted Marks (%)</label>
                        <input type="number" name="adjusted_marks" id="modal_adjusted_marks" 
                               min="0" max="100" step="0.1"
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Comment</label>
                        <textarea name="comment" id="modal_comment" rows="3" 
                                  placeholder="Enter validation comment..."
                                  class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"></textarea>
                    </div>
                    
                    <div class="flex items-center justify-end gap-3 pt-4 border-t border-gray-200">
                        <button type="button" onclick="closeValidationModal()" 
                                class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">
                            Cancel
                        </button>
                        <button type="submit" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                            Save Decision
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
function openValidationModal(studentId, currentMarks, currentDecision, currentComment, adjustedMarks) {
    document.getElementById('modal_student_id').value = studentId;
    document.getElementById('modal_current_marks').textContent = currentMarks.toFixed(1);
    document.getElementById('modal_decision').value = currentDecision;
    document.getElementById('modal_comment').value = currentComment;
    
    if (adjustedMarks) {
        document.getElementById('modal_adjusted_marks').value = adjustedMarks;
    }
    
    toggleAdjustedMarks();
    document.getElementById('validationForm').action = '{{ route('validator.validation-requests.validate', $validationRequest) }}';
    document.getElementById('validationModal').classList.remove('hidden');
}

function closeValidationModal() {
    document.getElementById('validationModal').classList.add('hidden');
}

function toggleAdjustedMarks() {
    const decision = document.getElementById('modal_decision').value;
    const container = document.getElementById('adjusted_marks_container');
    if (decision === 'modified') {
        container.classList.remove('hidden');
    } else {
        container.classList.add('hidden');
    }
}

function viewEvidence(studentId) {
    const modal = document.getElementById('evidenceModal');
    const content = document.getElementById('evidenceContent');
    const validationRequestId = {{ $validationRequest->id }};
    
    // Show modal with loading state
    modal.classList.remove('hidden');
    content.innerHTML = `
        <div class="text-center py-8">
            <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-indigo-600"></div>
            <p class="mt-2 text-sm text-gray-600">Loading evidence...</p>
        </div>
    `;
    
    // Fetch evidence data
    fetch(`/validator/units/${validationRequestId}/evidence/${studentId}`, {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json',
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.error) {
            content.innerHTML = `
                <div class="text-center py-8">
                    <p class="text-red-600">${data.error}</p>
                </div>
            `;
            return;
        }
        
        if (!data.files || data.files.length === 0) {
            content.innerHTML = `
                <div class="text-center py-8">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <p class="mt-2 text-sm text-gray-600">No evidence files found for this student.</p>
                </div>
            `;
            return;
        }
        
        // Display evidence files
        let html = `
            <div class="mb-4">
                <h4 class="text-sm font-medium text-gray-700">Student: ${data.student.name}</h4>
                <p class="text-xs text-gray-500">Admission: ${data.student.admission_number}</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        `;
        
        data.files.forEach(file => {
            // Use the file path directly - it should already be relative to storage/public
            const fileUrl = `/storage/${file.file_path}`;
            const fileSize = file.file_size ? (file.file_size / 1024).toFixed(2) + ' KB' : 'Unknown size';
            
            html += `
                <div class="border border-gray-200 rounded-lg overflow-hidden bg-gray-50">
                    <div class="p-2 bg-gray-100 border-b border-gray-200">
                        <p class="text-xs font-medium text-gray-700 truncate">${file.task_name || 'Evidence'}</p>
                        <p class="text-xs text-gray-500 truncate">${file.file_name}</p>
                    </div>
            `;
            
            if (file.file_type === 'image') {
                html += `
                    <div class="aspect-video bg-gray-100 flex items-center justify-center p-2">
                        <img src="${fileUrl}" 
                             alt="${file.file_name}" 
                             class="max-w-full max-h-full object-contain rounded cursor-pointer"
                             onclick="openImageModal('${fileUrl}', '${file.file_name}')">
                    </div>
                `;
            } else if (file.file_type === 'video') {
                html += `
                    <div class="aspect-video bg-gray-900">
                        <video controls class="w-full h-full">
                            <source src="${fileUrl}" type="${file.mime_type}">
                            Your browser does not support the video tag.
                        </video>
                    </div>
                `;
            } else if (file.file_type === 'audio') {
                html += `
                    <div class="p-4 bg-gray-100">
                        <audio controls class="w-full">
                            <source src="${fileUrl}" type="${file.mime_type}">
                            Your browser does not support the audio tag.
                        </audio>
                    </div>
                `;
            } else {
                html += `
                    <div class="p-4 bg-gray-100 text-center">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <p class="mt-2 text-xs text-gray-600">${file.file_name}</p>
                    </div>
                `;
            }
            
            html += `
                    <div class="p-2 bg-white border-t border-gray-200">
                        <a href="/validator/units/evidence/${file.id}/download" 
                           class="inline-flex items-center px-3 py-1 text-xs font-medium text-indigo-600 hover:text-indigo-900">
                            <svg class="h-4 w-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                            </svg>
                            Download
                        </a>
                        <span class="ml-2 text-xs text-gray-500">${fileSize}</span>
                    </div>
                </div>
            `;
        });
        
        html += `</div>`;
        content.innerHTML = html;
    })
    .catch(error => {
        console.error('Error loading evidence:', error);
        content.innerHTML = `
            <div class="text-center py-8">
                <p class="text-red-600">Error loading evidence. Please try again.</p>
            </div>
        `;
    });
}

function closeEvidenceModal() {
    document.getElementById('evidenceModal').classList.add('hidden');
}

function openImageModal(imageUrl, imageName) {
    // Create a simple image modal
    const modal = document.createElement('div');
    modal.className = 'fixed inset-0 bg-black bg-opacity-75 z-50 flex items-center justify-center';
    modal.innerHTML = `
        <div class="relative max-w-7xl max-h-full p-4">
            <button onclick="this.closest('.fixed').remove()" class="absolute top-4 right-4 text-white hover:text-gray-300 z-10">
                <svg class="h-8 w-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
            <img src="${imageUrl}" alt="${imageName}" class="max-w-full max-h-[90vh] object-contain">
        </div>
    `;
    document.body.appendChild(modal);
    modal.onclick = function(e) {
        if (e.target === modal) {
            modal.remove();
        }
    };
}
</script>
@endpush
@endsection
