<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>EPOE System - Electronic Portfolio of Evidence</title>
        <link href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="antialiased bg-gray-50">
        <div class="min-h-screen flex flex-col">
            <!-- Navigation -->
            @if (Route::has('login'))
                <div class="fixed top-0 right-0 px-6 py-4 z-10">
                    @auth
                        <a href="{{ url('/dashboard') }}" class="text-sm font-semibold text-gray-700 hover:text-gray-900">Dashboard</a>
                    @else
                        <a href="{{ route('login') }}" class="text-sm font-semibold text-gray-700 hover:text-gray-900">Log in</a>
                        @if (Route::has('register'))
                            <a href="{{ route('register') }}" class="ml-4 text-sm font-semibold text-gray-700 hover:text-gray-900">Register</a>
                        @endif
                    @endauth
                </div>
            @endif

            <!-- Hero Section -->
            <div class="flex-1 flex items-center justify-center px-4 sm:px-6 lg:px-8">
                <div class="max-w-4xl w-full text-center">
                    <div class="mb-8">
                        <h1 class="text-5xl font-bold text-gray-900 mb-4">
                            Electronic Portfolio of Evidence
                        </h1>
                    </div>

                    <!-- Role-Based Login Cards -->
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                        <!-- Admin -->
                        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow">
                            <div class="text-4xl mb-4">👨‍💼</div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Administrator</h3>
                            <p class="text-sm text-gray-600 mb-4">System management, user administration, and configuration</p>
                            <a href="{{ route('login') }}" class="inline-block bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 text-sm font-medium">
                                Login as Admin
                            </a>
                        </div>

                        <!-- HOD -->
                        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow">
                            <div class="text-4xl mb-4">👔</div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Head of Department</h3>
                            <p class="text-sm text-gray-600 mb-4">Department oversight and PoE approval</p>
                            <a href="{{ route('login') }}" class="inline-block bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 text-sm font-medium">
                                Login as HOD
                            </a>
                        </div>

                        <!-- Trainer -->
                        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow">
                            <div class="text-4xl mb-4">👨‍🏫</div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Trainer</h3>
                            <p class="text-sm text-gray-600 mb-4">Assess PoE submissions and provide feedback</p>
                            <a href="{{ route('login') }}" class="inline-block bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 text-sm font-medium">
                                Login as Trainer
                            </a>
                        </div>

                        <!-- Exams Office -->
                        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow">
                            <div class="text-4xl mb-4">📋</div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Exams Office</h3>
                            <p class="text-sm text-gray-600 mb-4">Verify submissions and forward for validation</p>
                            <a href="{{ route('login') }}" class="inline-block bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 text-sm font-medium">
                                Login as Exams Office
                            </a>
                        </div>

                        <!-- Validator -->
                        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow">
                            <div class="text-4xl mb-4">✅</div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Validator</h3>
                            <p class="text-sm text-gray-600 mb-4">Final validation and approval of PoE submissions</p>
                            <a href="{{ route('login') }}" class="inline-block bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 text-sm font-medium">
                                Login as Validator
                            </a>
                        </div>

                        <!-- Student -->
                        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow">
                            <div class="text-4xl mb-4">👨‍🎓</div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Student</h3>
                            <p class="text-sm text-gray-600 mb-4">Submit PoE evidence and track progress</p>
                            <a href="{{ route('login') }}" class="inline-block bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 text-sm font-medium">
                                Login as Student
                            </a>
                        </div>
                    </div>

                    <!-- Features -->
                    <div class="bg-white rounded-lg shadow-md p-8 mt-8">
                        <h2 class="text-2xl font-bold text-gray-900 mb-6">System Features</h2>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 text-left">
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">📚 Portfolio Management</h3>
                                <p class="text-sm text-gray-600">Submit and manage evidence with version control</p>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">📊 Analytics & Reports</h3>
                                <p class="text-sm text-gray-600">Comprehensive reporting at all levels</p>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">🔔 Notifications</h3>
                                <p class="text-sm text-gray-600">Real-time updates and deadline reminders</p>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">✅ Multi-Stage Review</h3>
                                <p class="text-sm text-gray-600">Trainer → HOD → Exams → Validator workflow</p>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">🔒 Secure Access</h3>
                                <p class="text-sm text-gray-600">Role-based access control and audit logs</p>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">📱 Mobile Friendly</h3>
                                <p class="text-sm text-gray-600">Access from any device, anywhere</p>
                            </div>
                        </div>
                    </div>

                    <!-- CTA -->
                    <div class="mt-8">
                        @guest
                            <a href="{{ route('register') }}" class="inline-block bg-green-600 text-white px-8 py-3 rounded-md hover:bg-green-700 font-semibold text-lg">
                                Register as Student
                            </a>
                            <p class="text-sm text-gray-500 mt-4">
                                Other roles? Contact your administrator for account creation
                            </p>
                        @endguest
                    </div>
                </div>
            </div>

            <!-- Footer -->
            <footer class="bg-gray-800 text-white py-4 text-center text-sm">
                <p>&copy; {{ date('Y') }} EPOE System - Electronic Portfolio of Evidence</p>
            </footer>
        </div>
    </body>
</html>
