<?php
    $isMobile = $isMobile ?? false;
    $userManagementOpen = request()->routeIs('admin.users.*');
?>

<!-- Dashboard -->
<a href="<?php echo e(route('admin.dashboard')); ?>" 
   <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
   class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
    </svg>
    Dashboard
</a>

<!-- User Management -->
<div class="pt-4" x-data="{ open: <?php echo e($userManagementOpen ? 'true' : 'false'); ?> }">
    <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-2 text-sm font-medium text-indigo-100 hover:bg-indigo-700 hover:text-white rounded-md">
        <div class="flex items-center">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
            </svg>
            <span>User Management</span>
        </div>
        <svg class="h-4 w-4 transition-transform" :class="{ 'rotate-90': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
        </svg>
    </button>
    <div x-show="open" x-transition class="mt-1 space-y-1 pl-11">
        <a href="<?php echo e(route('admin.users.index', ['role' => 'admin'])); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.users.*') && request('role') == 'admin' ? 'bg-indigo-900 text-white' : 'text-indigo-200 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-2 h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
            </svg>
            Administrators
        </a>
        <a href="<?php echo e(route('admin.users.index', ['role' => 'exams_office'])); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.users.*') && request('role') == 'exams_office' ? 'bg-indigo-900 text-white' : 'text-indigo-200 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-2 h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            Exams Office
        </a>
        <a href="<?php echo e(route('admin.users.index', ['role' => 'hod'])); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.users.*') && request('role') == 'hod' ? 'bg-indigo-900 text-white' : 'text-indigo-200 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-2 h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
            </svg>
            HODs
        </a>
        <a href="<?php echo e(route('admin.users.index', ['role' => 'trainer'])); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.users.*') && request('role') == 'trainer' ? 'bg-indigo-900 text-white' : 'text-indigo-200 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-2 h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
            </svg>
            Trainers
        </a>
        <a href="<?php echo e(route('admin.users.index', ['role' => 'validator'])); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.users.*') && request('role') == 'validator' ? 'bg-indigo-900 text-white' : 'text-indigo-200 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-2 h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            Validators
        </a>
        <a href="<?php echo e(route('admin.users.index', ['role' => 'student'])); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.users.*') && request('role') == 'student' ? 'bg-indigo-900 text-white' : 'text-indigo-200 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-2 h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l9-5-9-5-9 5 9 5z"></path>
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z"></path>
            </svg>
            Students
        </a>
    </div>
</div>

<!-- Portfolio -->
<div class="pt-4">
    <p class="px-3 text-xs font-semibold text-indigo-300 uppercase tracking-wider">Portfolio</p>
    <div class="mt-2 space-y-1">
        <a href="<?php echo e(route('admin.submissions.index')); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.submissions.*') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            Submissions
        </a>
    </div>
</div>

<!-- Academic -->
<div class="pt-4">
    <p class="px-3 text-xs font-semibold text-indigo-300 uppercase tracking-wider">Academic</p>
    <div class="mt-2 space-y-1">
        <a href="<?php echo e(route('admin.terms.index')); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.terms.*') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
            </svg>
            Terms
        </a>
        <a href="<?php echo e(route('admin.departments.index')); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.departments.*') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
            </svg>
            Departments
        </a>
        <a href="<?php echo e(route('admin.levels.index')); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.levels.*') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
            </svg>
            Levels
        </a>
        <a href="<?php echo e(route('admin.classes.index')); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.classes.*') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
            </svg>
            Classes
        </a>
        <a href="<?php echo e(route('admin.units.index')); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.units.*') && !request()->routeIs('admin.unit-allocations.*') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            Units/Modules
        </a>
        <a href="<?php echo e(route('admin.unit-allocations.index')); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.unit-allocations.*') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
            </svg>
            Unit Allocations
        </a>
    </div>
</div>

<!-- Reports -->
<div class="pt-4">
    <p class="px-3 text-xs font-semibold text-indigo-300 uppercase tracking-wider">Reports</p>
    <div class="mt-2 space-y-1">
        <a href="<?php echo e(route('admin.reports.index')); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.reports.*') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
            </svg>
            Reports & Analytics
        </a>
    </div>
</div>

<!-- History -->
<div class="pt-4">
    <p class="px-3 text-xs font-semibold text-indigo-300 uppercase tracking-wider">History</p>
    <div class="mt-2 space-y-1">
        <a href="<?php echo e(route('admin.history.index')); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.history.*') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            Past Terms
        </a>
    </div>
</div>

<!-- System -->
<div class="pt-4">
    <p class="px-3 text-xs font-semibold text-indigo-300 uppercase tracking-wider">System</p>
    <div class="mt-2 space-y-1">
        <a href="<?php echo e(route('admin.settings.index')); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.settings.*') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
            </svg>
            Settings
        </a>
        <a href="<?php echo e(route('admin.audit-logs.index')); ?>" 
           <?php if($isMobile): ?> @click="$store.sidebarOpen = false" <?php endif; ?>
           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('admin.audit-logs.*') ? 'bg-indigo-900 text-white' : 'text-indigo-100 hover:bg-indigo-700 hover:text-white'); ?>">
            <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            Audit Logs
        </a>
    </div>
</div>
<?php /**PATH D:\poe\resources\views/components/partials/admin-sidebar-nav.blade.php ENDPATH**/ ?>