

<?php $__env->startSection('title', 'Messages'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900">Messages</h1>
        <p class="mt-1 text-sm text-gray-600">View notifications and messages</p>
    </div>

    <div class="bg-white shadow rounded-lg">
        <div class="border-b border-gray-200">
            <nav class="flex -mb-px">
                <a href="#notifications" onclick="showTab('notifications')" class="tab-link py-4 px-6 text-sm font-medium border-b-2 border-blue-500 text-blue-600">
                    Notifications
                    <?php if($unreadNotifications > 0): ?>
                        <span class="ml-2 bg-red-600 text-white text-xs px-2 py-1 rounded-full"><?php echo e($unreadNotifications); ?></span>
                    <?php endif; ?>
                </a>
                <a href="#messages" onclick="showTab('messages')" class="tab-link py-4 px-6 text-sm font-medium border-b-2 border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300">
                    Direct Messages
                    <?php if($unreadMessages > 0): ?>
                        <span class="ml-2 bg-red-600 text-white text-xs px-2 py-1 rounded-full"><?php echo e($unreadMessages); ?></span>
                    <?php endif; ?>
                </a>
            </nav>
        </div>

        <!-- Notifications Tab -->
        <div id="notifications-tab" class="tab-content p-6">
            <?php if($notifications->count() > 0): ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="border border-gray-200 rounded-lg p-4 <?php echo e($notification->read_at ? 'bg-white' : 'bg-blue-50'); ?>">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <h3 class="text-sm font-medium text-gray-900"><?php echo e($notification->data['title'] ?? 'Notification'); ?></h3>
                                    <p class="text-sm text-gray-600 mt-1"><?php echo e($notification->data['message'] ?? ''); ?></p>
                                    <p class="text-xs text-gray-500 mt-2"><?php echo e($notification->created_at->diffForHumans()); ?></p>
                                </div>
                                <div class="ml-4">
                                    <?php if(!$notification->read_at): ?>
                                        <form action="<?php echo e(route('trainer.messages.notification.read', $notification->id)); ?>" method="POST" class="inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="text-xs text-blue-600 hover:text-blue-900">Mark as read</button>
                                        </form>
                                    <?php endif; ?>
                                    <a href="<?php echo e(route('trainer.messages.show-notification', $notification->id)); ?>" class="ml-2 text-xs text-blue-600 hover:text-blue-900">View</a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="mt-4">
                    <?php echo e($notifications->links()); ?>

                </div>
            <?php else: ?>
                <p class="text-sm text-gray-500 text-center py-8">No notifications found.</p>
            <?php endif; ?>
        </div>

        <!-- Messages Tab -->
        <div id="messages-tab" class="tab-content p-6 hidden">
            <?php if($messages->count() > 0): ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="border border-gray-200 rounded-lg p-4 <?php echo e($message->is_read ? 'bg-white' : 'bg-blue-50'); ?>">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <h3 class="text-sm font-medium text-gray-900">From: <?php echo e($message->sender->name); ?></h3>
                                    <p class="text-sm text-gray-600 mt-1"><?php echo e($message->subject); ?></p>
                                    <p class="text-sm text-gray-900 mt-2"><?php echo e(Str::limit($message->message, 150)); ?></p>
                                    <p class="text-xs text-gray-500 mt-2"><?php echo e($message->created_at->diffForHumans()); ?></p>
                                </div>
                                <div class="ml-4">
                                    <?php if(!$message->is_read): ?>
                                        <form action="<?php echo e(route('trainer.messages.read', $message)); ?>" method="POST" class="inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="text-xs text-blue-600 hover:text-blue-900">Mark as read</button>
                                        </form>
                                    <?php endif; ?>
                                    <a href="<?php echo e(route('trainer.messages.show', $message)); ?>" class="ml-2 text-xs text-blue-600 hover:text-blue-900">View</a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="mt-4">
                    <?php echo e($messages->links()); ?>

                </div>
            <?php else: ?>
                <p class="text-sm text-gray-500 text-center py-8">No messages found.</p>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function showTab(tab) {
            document.querySelectorAll('.tab-content').forEach(content => content.classList.add('hidden'));
            document.querySelectorAll('.tab-link').forEach(link => {
                link.classList.remove('border-blue-500', 'text-blue-600');
                link.classList.add('border-transparent', 'text-gray-500');
            });
            
            document.getElementById(tab + '-tab').classList.remove('hidden');
            event.target.classList.add('border-blue-500', 'text-blue-600');
            event.target.classList.remove('border-transparent', 'text-gray-500');
        }
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.trainer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/trainer/messages/index.blade.php ENDPATH**/ ?>