

<?php $__env->startSection('title', $unit->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4 sm:mb-6">
        <div class="flex items-center justify-between">
            <div class="flex-1 min-w-0">
                <h1 class="text-xl sm:text-2xl font-bold text-gray-900 truncate"><?php echo e($unit->name); ?></h1>
                <?php if($unit->code): ?>
                    <p class="text-sm text-gray-600 mt-1">Code: <?php echo e($unit->code); ?></p>
                <?php endif; ?>
                <?php if($unit->department): ?>
                    <p class="text-sm text-gray-600 truncate"><?php echo e($unit->department->name); ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php if($activeTerm): ?>
        <div class="mb-4 sm:mb-6 p-3 sm:p-4 bg-green-50 border border-green-200 rounded-lg">
            <p class="text-sm text-green-800"><strong>Active Term:</strong> <?php echo e($activeTerm->name); ?></p>
        </div>
    <?php endif; ?>

    <!-- Assignments Section -->
    <div class="bg-white rounded-lg shadow">
        <div class="p-4 sm:p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Assignments & Exams</h2>
            
            <?php if($assignments->count() > 0): ?>
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                    <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $isAvailable = $assignment->isAvailableForStudents();
                            $isOverdue = $assignment->isOverdue();
                        ?>
                        <div class="border-2 rounded-lg p-4 sm:p-5 transition-all <?php echo e($isAvailable ? 'border-gray-200 hover:border-green-300 hover:shadow-md cursor-pointer' : 'border-gray-200 bg-gray-50 opacity-75 cursor-not-allowed pointer-events-none'); ?>"
                             <?php if($isAvailable): ?> onclick="window.location='<?php echo e(route('student.assignments.show', $assignment)); ?>'" <?php endif; ?>>
                            <div class="flex items-start justify-between mb-3">
                                <div class="flex-1">
                                    <div class="flex items-center gap-2 mb-2">
                                        <?php if($isAvailable): ?>
                                            <a href="<?php echo e(route('student.assignments.show', $assignment)); ?>" class="font-semibold text-lg text-gray-900 hover:text-green-600">
                                                <?php echo e($assignment->title); ?>

                                            </a>
                                        <?php else: ?>
                                            <h3 class="font-semibold text-lg text-gray-500">
                                                <?php echo e($assignment->title); ?>

                                            </h3>
                                        <?php endif; ?>
                                    </div>
                                    <div class="flex flex-wrap gap-2 mb-3">
                                        <span class="px-2.5 py-1 text-xs font-medium rounded-full <?php echo e($assignment->getStatusBadgeClasses()); ?>">
                                            <?php echo e($assignment->getTypeLabel()); ?>

                                        </span>
                                        <?php if($isOverdue): ?>
                                            <span class="px-2.5 py-1 text-xs font-medium rounded-full bg-red-100 text-red-800 flex items-center gap-1">
                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                                                </svg>
                                                Overdue
                                            </span>
                                        <?php elseif(!$isAvailable): ?>
                                            <span class="px-2.5 py-1 text-xs font-medium rounded-full bg-blue-100 text-blue-800 flex items-center gap-1">
                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                </svg>
                                                Starts <?php echo e($assignment->start_date->format('M d, Y')); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="px-2.5 py-1 text-xs font-medium rounded-full bg-green-100 text-green-800 flex items-center gap-1">
                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                </svg>
                                                Available
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            
                            <?php if($assignment->description): ?>
                                <p class="text-sm text-gray-600 mb-3 line-clamp-2"><?php echo e($assignment->description); ?></p>
                            <?php endif; ?>
                            
                            <div class="space-y-2 mb-3">
                                <div class="flex items-center text-sm text-gray-600">
                                    <svg class="w-4 h-4 mr-2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                    </svg>
                                    <?php if($assignment->total_marks): ?>
                                        <span class="font-medium"><?php echo e($assignment->total_marks); ?> Marks</span>
                                    <?php else: ?>
                                        <span>No marks specified</span>
                                    <?php endif; ?>
                                </div>
                                <?php if($assignment->due_date): ?>
                                    <div class="flex items-center text-sm <?php echo e($isOverdue ? 'text-red-600' : 'text-gray-600'); ?>">
                                        <svg class="w-4 h-4 mr-2 <?php echo e($isOverdue ? 'text-red-500' : 'text-gray-400'); ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                        <span>Due: <?php echo e($assignment->due_date->format('M d, Y')); ?> at <?php echo e($assignment->due_date->format('H:i')); ?></span>
                                    </div>
                                <?php endif; ?>
                                        <?php if($assignment->type === 'practical'): ?>
                                    <div class="flex items-center text-sm text-gray-600">
                                        <svg class="w-4 h-4 mr-2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                        <span>Practical Assessment</span>
                                    </div>
                                <?php elseif($assignment->attachments && count($assignment->attachments) > 0): ?>
                                    <div class="flex items-center text-sm text-gray-600">
                                        <svg class="w-4 h-4 mr-2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                                        </svg>
                                        <span><?php echo e(count($assignment->attachments)); ?> <?php echo e(Str::plural('attachment', count($assignment->attachments))); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <?php if($assignment->student_submission): ?>
                                <div class="mt-3 pt-3 border-t border-gray-200">
                                    <div class="flex items-center justify-between">
                                        <div class="flex items-center gap-2">
                                            <span class="px-2.5 py-1 text-xs font-semibold rounded-full <?php echo e($assignment->student_submission->getStatusBadgeClasses()); ?>">
                                                <?php echo e(ucfirst($assignment->student_submission->status)); ?>

                                            </span>
                                            <?php if($assignment->student_submission->marks !== null): ?>
                                                <span class="text-sm font-semibold text-gray-900">
                                                    <?php echo e($assignment->student_submission->marks); ?>/<?php echo e($assignment->total_marks ?? 'N/A'); ?>

                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        <?php if($isAvailable): ?>
                                            <a href="<?php echo e(route('student.assignments.show', $assignment)); ?>" class="text-sm text-green-600 hover:text-green-700 font-medium">
                                                View →
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php elseif($isAvailable): ?>
                                <div class="mt-3 pt-3 border-t border-gray-200">
                                    <a href="<?php echo e(route('student.assignments.show', $assignment)); ?>" class="inline-flex items-center justify-center w-full px-4 py-2 bg-green-600 text-white text-sm font-medium rounded-md hover:bg-green-700 transition-colors">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                                        </svg>
                                        Start Assignment
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="mt-3 pt-3 border-t border-gray-200">
                                    <div class="text-center py-2">
                                        <p class="text-xs text-gray-500">Available on <?php echo e($assignment->start_date->format('M d, Y')); ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No assignments yet</h3>
                    <p class="mt-1 text-sm text-gray-500">Your trainer hasn't published any assignments for this unit.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/student/units/show.blade.php ENDPATH**/ ?>