<?php $__env->startSection('title', 'Units Pending Validation'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Validation Requests</h1>
    <p class="mt-1 text-sm text-gray-600">Review and validate units pushed by trainers</p>
</div>

<?php if($activeTerm): ?>
    <div class="mb-6 p-4 bg-indigo-50 border border-indigo-200 rounded-lg">
        <p class="text-sm text-indigo-800"><strong>Active Term:</strong> <?php echo e($activeTerm->name); ?></p>
    </div>
<?php endif; ?>

<!-- Filters -->
<div class="bg-white rounded-lg shadow mb-6 p-6">
    <form method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
            <select name="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">All Statuses</option>
                <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="approved" <?php echo e(request('status') == 'approved' ? 'selected' : ''); ?>>Approved</option>
                <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                <option value="returned_to_trainer" <?php echo e(request('status') == 'returned_to_trainer' ? 'selected' : ''); ?>>Returned to Trainer</option>
            </select>
        </div>
        <?php if($classes->count() > 0): ?>
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Class</label>
            <select name="class" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">All Classes</option>
                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($class->id); ?>" <?php echo e(request('class') == $class->id ? 'selected' : ''); ?>><?php echo e($class->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <?php endif; ?>
        <?php if($units->count() > 0): ?>
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Unit</label>
            <select name="unit" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">All Units</option>
                <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($unit->id); ?>" <?php echo e(request('unit') == $unit->id ? 'selected' : ''); ?>><?php echo e($unit->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <?php endif; ?>
        <div class="flex items-end gap-2">
            <button type="submit" class="flex-1 bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">Filter</button>
            <?php if(request()->anyFilled(['status', 'class', 'unit'])): ?>
            <a href="<?php echo e(route('validator.validation-requests.index')); ?>" class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">Clear</a>
            <?php endif; ?>
        </div>
    </form>
</div>

<!-- Units Table -->
<?php if($validationRequests->count() > 0): ?>
<div class="bg-white shadow rounded-lg overflow-hidden">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Department / Class</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Trainer</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date Pushed</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Action</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__currentLoopData = $validationRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium text-gray-900"><?php echo e($request->unit->name); ?></div>
                        <div class="text-sm text-gray-500">Code: <?php echo e($request->unit->code); ?></div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900"><?php echo e($request->schoolClass->name); ?></div>
                        <?php if($request->schoolClass->department): ?>
                            <div class="text-sm text-gray-500"><?php echo e($request->schoolClass->department->name); ?></div>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                        <?php echo e($request->submitter->name); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                        <?php echo e($request->submitted_at->format('M d, Y H:i')); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 py-1 text-xs font-medium rounded-full
                            <?php if($request->status === 'pending'): ?> bg-yellow-100 text-yellow-800
                            <?php elseif($request->status === 'approved'): ?> bg-green-100 text-green-800
                            <?php elseif($request->status === 'rejected'): ?> bg-red-100 text-red-800
                            <?php else: ?> bg-blue-100 text-blue-800
                            <?php endif; ?>">
                            <?php echo e(ucfirst(str_replace('_', ' ', $request->status))); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <div class="flex flex-col sm:flex-row sm:items-center gap-2">
                            <a href="<?php echo e(route('validator.validation-requests.show', ['class' => $request->schoolClass->id, 'unit' => $request->unit->id])); ?>" 
                               class="inline-flex items-center px-3 py-1.5 rounded-full text-xs font-medium border border-indigo-600 text-indigo-700 bg-white hover:bg-indigo-50">
                                📊 View Marks
                            </a>
                            <a href="<?php echo e(route('validator.validation-requests.portfolio', $request->id)); ?>"
                               class="inline-flex items-center px-3 py-1.5 rounded-full text-xs font-medium border border-gray-300 text-gray-700 bg-white hover:bg-gray-50">
                                📁 View Portfolio
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    
    <!-- Pagination -->
    <?php if($validationRequests->hasPages()): ?>
    <div class="px-6 py-4 border-t border-gray-200">
        <?php echo e($validationRequests->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php else: ?>
<div class="bg-white shadow rounded-lg p-12 text-center">
    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
    </svg>
    <h3 class="mt-2 text-sm font-medium text-gray-900">No validation requests found</h3>
    <p class="mt-1 text-sm text-gray-500">
        <?php if($activeTerm): ?>
            There are no validation requests for the active term (<?php echo e($activeTerm->name); ?>) matching your filters.
        <?php else: ?>
            No validation requests found.
        <?php endif; ?>
    </p>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.validator', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/validator/units/index.blade.php ENDPATH**/ ?>