

<?php $__env->startSection('title', 'Upload Practical Evidence'); ?>
<?php $__env->startSection('page-title', 'Upload Practical Evidence'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4 sm:mb-6">
        <a href="<?php echo e(route('student.submissions.index')); ?>" class="text-indigo-600 hover:text-indigo-900 flex items-center touch-manipulation">
            <svg class="h-5 w-5 mr-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Portfolio Evidence
        </a>
    </div>

    <div class="bg-white shadow-sm rounded-lg overflow-hidden">
        <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-gray-50">
            <h3 class="text-base sm:text-lg font-semibold text-gray-900">Upload Practical Evidence</h3>
            <p class="mt-1 text-sm text-gray-600">Upload media evidence showing you performing the required unit task (e.g. cable termination, PC assembly). This is not an assignment. Your trainer will review the evidence, and it will be made available to the verifier when the unit is submitted for verification.</p>
        </div>

        <form method="POST" action="<?php echo e(route('student.submissions.store')); ?>" enctype="multipart/form-data" class="px-4 sm:px-6 py-4 sm:py-6">
            <?php echo csrf_field(); ?>

            <?php if($activeTerm): ?>
                <div class="mb-6 p-4 bg-blue-50 border border-blue-200 rounded-lg">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-blue-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <p class="text-sm text-blue-800">
                            <strong>Active Term:</strong> <?php echo e($activeTerm->name); ?>

                        </p>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Class Selection -->
            <div class="mb-6">
                <label for="class_id" class="block text-sm font-medium text-gray-700 mb-2">
                    Class <span class="text-red-500">*</span>
                </label>
                <select name="class_id" id="class_id" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-base <?php $__errorArgs = ['class_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="">Select a class</option>
                    <?php $__currentLoopData = $enrolledClasses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($class->id); ?>" <?php echo e(old('class_id', $selectedClass?->id) == $class->id ? 'selected' : ''); ?>>
                            <?php echo e($class->name); ?>

                            <?php if($class->code): ?> (<?php echo e($class->code); ?>) <?php endif; ?>
                            - <?php echo e($class->department->name); ?>

                            <?php if($class->level): ?> - <?php echo e($class->level->name); ?> <?php endif; ?>
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['class_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <?php if($enrolledClasses->isEmpty()): ?>
                    <p class="mt-1 text-sm text-yellow-600">You are not enrolled in any classes for the active term.</p>
                <?php endif; ?>
            </div>

            <!-- Unit Selection -->
            <div class="mb-6">
                <label for="unit_id" class="block text-sm font-medium text-gray-700 mb-2">
                    Unit <span class="text-red-500">*</span>
                </label>
                <select name="unit_id" id="unit_id" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-base <?php $__errorArgs = ['unit_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="">Select a unit</option>
                    <?php $__currentLoopData = $assignedUnits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($unit->id); ?>" <?php echo e(old('unit_id', $selectedUnit?->id) == $unit->id ? 'selected' : ''); ?>>
                            <?php echo e($unit->name); ?>

                            <?php if($unit->code): ?> (<?php echo e($unit->code); ?>) <?php endif; ?>
                            - <?php echo e($unit->department->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['unit_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <?php if($assignedUnits->isEmpty()): ?>
                    <p class="mt-1 text-sm text-yellow-600">No units are assigned to your enrolled classes.</p>
                <?php endif; ?>
            </div>

            <!-- Task Name -->
            <div class="mb-6">
                <label for="task_name" class="block text-sm font-medium text-gray-700 mb-2">
                    Task Name <span class="text-red-500">*</span>
                </label>
                <input type="text" name="task_name" id="task_name" required value="<?php echo e(old('task_name')); ?>" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 <?php $__errorArgs = ['task_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="e.g. RJ45 Cable Termination, PC Assembly, Network Configuration">
                <?php $__errorArgs = ['task_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <p class="mt-1 text-xs text-gray-500">Enter the name of the task you performed</p>
            </div>

            <!-- Notes -->
            <div class="mb-6">
                <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">
                    Notes (Optional)
                </label>
                <textarea name="notes" id="notes" rows="4" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Add any additional notes or comments about the evidence..."><?php echo e(old('notes')); ?></textarea>
                <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <p class="mt-1 text-xs text-gray-500">Maximum 1000 characters</p>
            </div>

            <!-- File Upload -->
            <div class="mb-6" id="media-evidence-wrap">
                <label for="files" class="block text-sm font-medium text-gray-700 mb-2">
                    Media Evidence <span class="text-red-500">*</span>
                </label>
                <input type="file" name="files[]" id="files" multiple required accept=".pdf,.doc,.docx,.jpg,.jpeg,.png,.mp4,.mp3,.wav" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100 <?php $__errorArgs = ['files'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" data-max-bytes="10485760">
                <?php $__errorArgs = ['files'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <?php $__errorArgs = ['files.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <p class="mt-1 text-xs text-gray-500">
                    Allowed file types: PDF, DOC, DOCX, JPG, JPEG, PNG, MP4, MP3, WAV. Maximum file size: 10MB per file. You can select multiple files.
                </p>
                <p id="files-chosen" class="mt-2 text-sm text-indigo-600 hidden" aria-live="polite"></p>
            </div>

            <!-- Submit Button -->
            <div class="flex flex-col-reverse sm:flex-row items-stretch sm:items-center justify-end gap-3 pt-4 border-t border-gray-200">
                <a href="<?php echo e(route('student.submissions.index')); ?>" class="inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 touch-manipulation">
                    Cancel
                </a>
                <button type="submit" class="inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 touch-manipulation">
                    Upload Evidence
                </button>
            </div>
        </form>
    </div>

    <div class="mt-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
        <div class="flex">
            <svg class="w-5 h-5 text-blue-600 mr-2 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            <div>
                <h4 class="text-sm font-semibold text-blue-900">Important</h4>
                <p class="mt-1 text-sm text-blue-700">
                    This is <strong>not an assignment</strong>. You are uploading practical evidence to demonstrate competency. Your trainer will review the evidence, and it will be made available to the verifier when the unit is submitted for verification.
                </p>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
    (function() {
        var MAX_SIZE_BYTES = 10 * 1024 * 1024; // 10MB
        var MAX_SIZE_LABEL = '10MB';
        var fileInput = document.getElementById('files');
        var form = fileInput && fileInput.closest('form');
        var filesChosenEl = document.getElementById('files-chosen');

        function formatBytes(bytes) {
            if (bytes < 1024) return bytes + ' B';
            if (bytes < 1024 * 1024) return (bytes / 1024).toFixed(1) + ' KB';
            return (bytes / (1024 * 1024)).toFixed(1) + ' MB';
        }

        function getOversizedFiles(files) {
            var list = [];
            for (var i = 0; i < files.length; i++) {
                if (files[i].size > MAX_SIZE_BYTES) {
                    list.push({ name: files[i].name, size: files[i].size });
                }
            }
            return list;
        }

        function showSizeWarning(oversized) {
            var msg = 'The following file(s) exceed the maximum size of ' + MAX_SIZE_LABEL + ' per file:\n\n';
            oversized.forEach(function(f) {
                msg += '• ' + f.name + ' (' + formatBytes(f.size) + ')\n';
            });
            msg += '\nPlease choose smaller files or remove them from the selection.';
            alert(msg);
        }

        function updateFilesChosenLabel() {
            if (!filesChosenEl || !fileInput) return;
            var files = fileInput.files;
            if (files.length === 0) {
                filesChosenEl.classList.add('hidden');
                filesChosenEl.textContent = '';
                return;
            }
            var oversized = getOversizedFiles(files);
            if (oversized.length > 0) {
                showSizeWarning(oversized);
                fileInput.value = '';
                filesChosenEl.classList.add('hidden');
                filesChosenEl.textContent = '';
                return;
            }
            filesChosenEl.classList.remove('hidden');
            filesChosenEl.textContent = files.length === 1
                ? '1 file chosen: ' + files[0].name
                : files.length + ' files chosen: ' + Array.from(files).map(function(f) { return f.name; }).join(', ');
        }

        if (fileInput) {
            fileInput.addEventListener('change', function() {
                updateFilesChosenLabel();
            });
        }

        if (form) {
            form.addEventListener('submit', function(e) {
                var files = fileInput.files;
                if (files.length === 0) return;
                var oversized = getOversizedFiles(files);
                if (oversized.length > 0) {
                    e.preventDefault();
                    showSizeWarning(oversized);
                    return false;
                }
            });
        }
    })();
    </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/student/submissions/create.blade.php ENDPATH**/ ?>