<?php $__env->startSection('title', 'Portfolio Evidence'); ?>
<?php $__env->startSection('page-title', 'Portfolio Evidence'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4 sm:mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div class="flex-1 min-w-0">
            <h1 class="text-xl sm:text-2xl font-bold text-gray-900">Portfolio Evidence</h1>
            <p class="mt-1 text-sm text-gray-600">Upload and manage your practical evidence</p>
        </div>
        <a href="<?php echo e(route('student.submissions.create')); ?>" class="w-full sm:w-auto inline-flex items-center justify-center px-4 py-3 sm:py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs sm:text-sm text-white uppercase tracking-widest hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150 relative z-10 touch-manipulation" style="min-height: 44px;">
            <svg class="w-4 h-4 sm:w-5 sm:h-5 mr-2 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
            </svg>
            <span>Upload Evidence</span>
        </a>
    </div>

    <?php if($activeTerm): ?>
        <div class="mb-4 p-4 bg-blue-50 border border-blue-200 rounded-lg">
            <div class="flex items-center">
                <svg class="w-5 h-5 text-blue-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <p class="text-sm text-blue-800">
                    <strong>Active Term:</strong> <?php echo e($activeTerm->name); ?>

                </p>
            </div>
        </div>
    <?php endif; ?>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-5 gap-3 sm:gap-4 mb-4 sm:mb-6">
        <a href="<?php echo e(route('student.submissions.index', ['status' => ''])); ?>" class="bg-white rounded-lg shadow p-3 sm:p-4 hover:shadow-md transition-shadow touch-manipulation block">
            <div class="text-center">
                <p class="text-xs sm:text-sm font-medium text-gray-600">Total</p>
                <p class="text-xl sm:text-2xl font-bold text-gray-900"><?php echo e($stats['total']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('student.submissions.index', ['status' => 'submitted'])); ?>" class="bg-white rounded-lg shadow p-3 sm:p-4 hover:shadow-md transition-shadow touch-manipulation block">
            <div class="text-center">
                <p class="text-xs sm:text-sm font-medium text-gray-600">Submitted</p>
                <p class="text-xl sm:text-2xl font-bold text-blue-600"><?php echo e($stats['submitted']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('student.submissions.index', ['status' => 'reviewed'])); ?>" class="bg-white rounded-lg shadow p-3 sm:p-4 hover:shadow-md transition-shadow touch-manipulation block">
            <div class="text-center">
                <p class="text-xs sm:text-sm font-medium text-gray-600">Reviewed</p>
                <p class="text-xl sm:text-2xl font-bold text-yellow-600"><?php echo e($stats['reviewed']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('student.submissions.index', ['status' => 'accepted'])); ?>" class="bg-white rounded-lg shadow p-3 sm:p-4 hover:shadow-md transition-shadow touch-manipulation block">
            <div class="text-center">
                <p class="text-xs sm:text-sm font-medium text-gray-600">Accepted</p>
                <p class="text-xl sm:text-2xl font-bold text-green-600"><?php echo e($stats['accepted']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('student.submissions.index', ['status' => 'rejected'])); ?>" class="bg-white rounded-lg shadow p-3 sm:p-4 hover:shadow-md transition-shadow touch-manipulation block">
            <div class="text-center">
                <p class="text-xs sm:text-sm font-medium text-gray-600">Rejected</p>
                <p class="text-xl sm:text-2xl font-bold text-red-600"><?php echo e($stats['rejected']); ?></p>
            </div>
        </a>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow-sm p-4 sm:p-6 mb-4 sm:mb-6">
        <form method="GET" action="<?php echo e(route('student.submissions.index')); ?>" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div class="hidden sm:block">
                <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                <select name="status" id="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-base">
                    <option value="">All Statuses</option>
                    <option value="submitted" <?php echo e(request('status') == 'submitted' ? 'selected' : ''); ?>>Submitted</option>
                    <option value="reviewed" <?php echo e(request('status') == 'reviewed' ? 'selected' : ''); ?>>Reviewed</option>
                    <option value="accepted" <?php echo e(request('status') == 'accepted' ? 'selected' : ''); ?>>Accepted</option>
                    <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                </select>
            </div>
            <div>
                <label for="unit" class="block text-sm font-medium text-gray-700 mb-1">Unit</label>
                <select name="unit" id="unit" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Units</option>
                    <?php $__currentLoopData = $assignedUnits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($unit->id); ?>" <?php echo e(request('unit') == $unit->id ? 'selected' : ''); ?>>
                            <?php echo e($unit->name); ?> <?php if($unit->code): ?>(<?php echo e($unit->code); ?>)<?php endif; ?>
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label for="class" class="block text-sm font-medium text-gray-700 mb-1">Class</label>
                <select name="class" id="class" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Classes</option>
                    <?php $__currentLoopData = $enrolledClasses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($class->id); ?>" <?php echo e(request('class') == $class->id ? 'selected' : ''); ?>>
                            <?php echo e($class->name); ?> <?php if($class->code): ?>(<?php echo e($class->code); ?>)<?php endif; ?>
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="md:col-span-3">
                <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <div class="flex flex-col sm:flex-row gap-2">
                    <input type="text" name="search" id="search" value="<?php echo e(request('search')); ?>" placeholder="Search by unit name or code..." class="flex-1 min-w-0 rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-base">
                    <div class="flex gap-2">
                        <button type="submit" class="flex-1 sm:flex-none px-4 py-2.5 min-h-[44px] bg-indigo-600 text-white rounded-md hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 touch-manipulation">
                            Filter
                        </button>
                        <a href="<?php echo e(route('student.submissions.index')); ?>" class="flex-1 sm:flex-none inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300 touch-manipulation">
                            Clear
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <!-- Practical Evidence Table (grouped by task) -->
    <div class="bg-white rounded-lg shadow-sm overflow-hidden">
        <?php if(isset($groupedEvidences) && $groupedEvidences->count() > 0): ?>
            <div class="overflow-x-auto -mx-3 sm:mx-0" style="-webkit-overflow-scrolling: touch;">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-3 py-2 sm:px-6 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit</th>
                            <th class="px-3 py-2 sm:px-6 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Task</th>
                            <th class="px-3 py-2 sm:px-6 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                            <th class="px-3 py-2 sm:px-6 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-3 py-2 sm:px-6 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Uploaded</th>
                            <th class="px-3 py-2 sm:px-6 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $groupedEvidences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                /** @var \Illuminate\Support\Collection|\App\Models\PracticalEvidence[] $group */
                                $evidence = $group->first();
                                $mediaCount = $group->count();
                                $types = $group->pluck('evidence_type')->unique()->values();
                                $latestUploaded = $group->max('uploaded_at');

                                $statusValues = $group->pluck('status')->unique()->values();
                                $statusLabel = $statusValues->count() === 1 ? ucfirst($evidence->status) : 'Mixed';
                                $statusClasses = $statusValues->count() === 1 
                                    ? ($evidence->isAccepted() ? 'bg-green-100 text-green-800' 
                                        : ($evidence->isRejected() ? 'bg-red-100 text-red-800' 
                                        : ($evidence->isReviewed() ? 'bg-yellow-100 text-yellow-800' 
                                        : 'bg-blue-100 text-blue-800')))
                                    : 'bg-yellow-100 text-yellow-800';
                            ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-3 py-2 sm:px-6 sm:py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($evidence->unit->name); ?></div>
                                    <?php if($evidence->unit->code): ?>
                                        <div class="text-sm text-gray-500"><?php echo e($evidence->unit->code); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-3 py-2 sm:px-6 sm:py-4">
                                    <div class="text-sm font-medium text-gray-900">
                                        <?php echo e($evidence->task_name); ?>

                                        <?php if($mediaCount > 1): ?>
                                            <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-gray-100 text-gray-700">
                                                <?php echo e($mediaCount); ?> media
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($evidence->notes): ?>
                                        <div class="text-xs text-gray-500 mt-1 truncate max-w-xs"><?php echo e(Str::limit($evidence->notes, 50)); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-3 py-2 sm:px-6 sm:py-4 whitespace-nowrap">
                                    <div class="flex flex-wrap gap-1">
                                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $badgeClasses = match($type) {
                                                    'video' => 'bg-red-100 text-red-800',
                                                    'image' => 'bg-green-100 text-green-800',
                                                    'audio' => 'bg-purple-100 text-purple-800',
                                                    default => 'bg-blue-100 text-blue-800',
                                                };
                                            ?>
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($badgeClasses); ?>">
                                                <?php echo e(ucfirst($type)); ?>

                                            </span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </td>
                                <td class="px-3 py-2 sm:px-6 sm:py-4 whitespace-nowrap">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($statusClasses); ?>">
                                        <?php echo e($statusLabel); ?>

                                    </span>
                                </td>
                                <td class="px-3 py-2 sm:px-6 sm:py-4 whitespace-nowrap text-sm text-gray-500">
                                    <?php echo e(\Illuminate\Support\Carbon::parse($latestUploaded)->format('M d, Y')); ?>

                                </td>
                                <td class="px-3 py-2 sm:px-6 sm:py-4 whitespace-nowrap text-sm font-medium">
                                    <a href="<?php echo e(route('student.submissions.show', $evidence)); ?>" class="inline-flex items-center min-h-[44px] sm:min-h-0 text-indigo-600 hover:text-indigo-900 touch-manipulation">View</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="p-12 text-center">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No evidence uploaded</h3>
                <p class="mt-1 text-sm text-gray-500">Get started by uploading your practical evidence.</p>
                <div class="mt-6">
                    <a href="<?php echo e(route('student.submissions.create')); ?>" class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                        Upload Evidence
                    </a>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/student/submissions/index.blade.php ENDPATH**/ ?>