

<?php $__env->startSection('title', 'My Progress'); ?>
<?php $__env->startSection('page-title', 'My Progress'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl font-bold text-gray-900">My Progress</h1>
        <p class="mt-1 text-sm text-gray-600">Track your portfolio submission progress and completion status</p>
    </div>

    <?php if($activeTerm): ?>
        <div class="mb-4 sm:mb-6 p-4 bg-blue-50 border border-blue-200 rounded-lg">
            <div class="flex items-center">
                <svg class="w-5 h-5 text-blue-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <p class="text-sm text-blue-800">
                    <strong>Active Term:</strong> <?php echo e($activeTerm->name); ?>

                </p>
            </div>
        </div>
    <?php else: ?>
        <div class="mb-6 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
            <div class="flex items-center">
                <svg class="w-5 h-5 text-yellow-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                </svg>
                <p class="text-sm text-yellow-800">
                    <strong>No Active Term:</strong> Please contact your administrator.
                </p>
            </div>
        </div>
    <?php endif; ?>

    <!-- Overall Progress Card -->
    <div class="bg-white rounded-lg shadow-sm p-4 sm:p-6 mb-4 sm:mb-6">
        <h2 class="text-base sm:text-lg font-semibold text-gray-900 mb-1">Overall Progress</h2>
        <p class="text-sm text-gray-500 mb-4">Based on units with at least one submission (completion) and units approved by the validator.</p>
        
        <!-- Completion: units with a submission -->
        <div class="mb-6">
            <div class="flex justify-between items-center mb-2">
                <span class="text-sm font-medium text-gray-700">Completion (units submitted)</span>
                <span class="text-sm font-bold text-gray-900"><?php echo e($stats['completion_percentage'] ?? 0); ?>%</span>
            </div>
            <div class="w-full bg-gray-200 rounded-full h-4">
                <div class="bg-indigo-600 h-4 rounded-full transition-all duration-300" style="width: <?php echo e($stats['completion_percentage'] ?? 0); ?>%"></div>
            </div>
            <div class="flex justify-between text-xs text-gray-500 mt-1">
                <span><?php echo e($stats['submitted_units'] ?? 0); ?> of <?php echo e($stats['total_units'] ?? 0); ?> units with a submission</span>
                <span><?php echo e($stats['pending_units'] ?? 0); ?> not yet submitted</span>
            </div>
        </div>

        <!-- Statistics Grid -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-3 sm:gap-4">
            <div class="text-center p-4 bg-gray-50 rounded-lg">
                <p class="text-2xl font-bold text-gray-900"><?php echo e($stats['total_units'] ?? 0); ?></p>
                <p class="text-sm text-gray-600 mt-1">Total Units</p>
            </div>
            <div class="text-center p-4 bg-green-50 rounded-lg">
                <p class="text-2xl font-bold text-green-600"><?php echo e($stats['submitted_units'] ?? 0); ?></p>
                <p class="text-sm text-gray-600 mt-1">With Submission</p>
            </div>
            <div class="text-center p-4 bg-blue-50 rounded-lg">
                <p class="text-2xl font-bold text-blue-600"><?php echo e($stats['approved_units'] ?? 0); ?></p>
                <p class="text-sm text-gray-600 mt-1">Approved</p>
            </div>
            <div class="text-center p-4 bg-yellow-50 rounded-lg">
                <p class="text-2xl font-bold text-yellow-600"><?php echo e($stats['pending_units'] ?? 0); ?></p>
                <p class="text-sm text-gray-600 mt-1">Pending</p>
            </div>
        </div>

        <!-- Approval rate: always show when we have units -->
        <?php if(($stats['total_units'] ?? 0) > 0): ?>
            <div class="mt-6 pt-6 border-t border-gray-200">
                <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                    <div>
                        <p class="text-sm font-medium text-gray-700">Approval Rate</p>
                        <p class="text-2xl font-bold text-green-600 mt-1"><?php echo e($stats['approved_percentage'] ?? 0); ?>%</p>
                        <p class="text-xs text-gray-500 mt-1"><?php echo e($stats['approved_units'] ?? 0); ?> of <?php echo e($stats['total_units'] ?? 0); ?> units approved</p>
                    </div>
                    <?php if(($stats['average_marks'] ?? 0) > 0): ?>
                        <div class="sm:text-right">
                            <p class="text-sm font-medium text-gray-700">Average Marks</p>
                            <p class="text-2xl font-bold text-gray-900 mt-1"><?php echo e($stats['average_marks']); ?></p>
                            <p class="text-xs text-gray-500 mt-1">Based on <?php echo e($stats['submissions_with_marks'] ?? 0); ?> submissions</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Download Unit Documents (unified: unit → type → download) -->
    <?php if($activeTerm): ?>
        <?php if(isset($progressUnits) && $progressUnits->count() > 0): ?>
            <div class="bg-white rounded-lg shadow-sm p-4 sm:p-6 mb-4 sm:mb-6">
                <h2 class="text-base sm:text-lg font-semibold text-gray-900 mb-2">Download Unit Documents</h2>
                <p class="text-sm text-gray-600 mb-4">Select a unit, choose what to download (Practicals, Exams, or Portfolio), then click Download PDF.</p>

                <form action="<?php echo e(route('student.progress.unit-document-pdf')); ?>" method="get" target="_blank" rel="noopener" class="space-y-4">
                    <div>
                        <label for="progress-unit-doc-select" class="block text-sm font-medium text-gray-700 mb-1">Step 1: Select unit</label>
                        <select id="progress-unit-doc-select" name="unit" required class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-sm min-h-[44px] sm:min-h-0">
                            <option value="">Select a unit…</option>
                            <?php $__currentLoopData = $progressUnits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($u->id); ?>"
                                    data-practicals="<?php echo e($unitDocumentCounts[$u->id]['practicals'] ?? 0); ?>"
                                    data-exams="<?php echo e($unitDocumentCounts[$u->id]['exams'] ?? 0); ?>"
                                    data-portfolio="<?php echo e($unitDocumentCounts[$u->id]['portfolio'] ?? 0); ?>"
                                ><?php echo e($u->name); ?><?php if($u->code): ?> (<?php echo e($u->code); ?>)<?php endif; ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Step 2: Choose what to download</label>
                        <div class="space-y-2">
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input type="radio" name="type" value="practicals" required class="rounded-full border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                <span class="text-sm text-gray-900"><span id="label-practicals">Practicals</span></span>
                            </label>
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input type="radio" name="type" value="exams" class="rounded-full border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                <span class="text-sm text-gray-900"><span id="label-exams">Exams</span></span>
                            </label>
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input type="radio" name="type" value="portfolio" class="rounded-full border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                <span class="text-sm text-gray-900"><span id="label-portfolio">Portfolio</span></span>
                            </label>
                        </div>
                    </div>

                    <div>
                        <button type="submit" class="inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] sm:min-h-0 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 touch-manipulation">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            Step 3: Download PDF
                        </button>
                    </div>
                </form>

                <script>
                    (function() {
                        var sel = document.getElementById('progress-unit-doc-select');
                        var labels = {
                            practicals: document.getElementById('label-practicals'),
                            exams: document.getElementById('label-exams'),
                            portfolio: document.getElementById('label-portfolio')
                        };
                        function updateLabels() {
                            var opt = sel.options[sel.selectedIndex];
                            if (!opt || !opt.value) {
                                labels.practicals.textContent = 'Practicals';
                                labels.exams.textContent = 'Exams';
                                labels.portfolio.textContent = 'Portfolio';
                                return;
                            }
                            var p = parseInt(opt.getAttribute('data-practicals') || 0, 10);
                            var e = parseInt(opt.getAttribute('data-exams') || 0, 10);
                            var po = parseInt(opt.getAttribute('data-portfolio') || 0, 10);
                            labels.practicals.textContent = p > 0 ? 'Practicals (' + p + ' file' + (p !== 1 ? 's' : '') + ')' : 'Practicals';
                            labels.exams.textContent = e > 0 ? 'Exams (' + e + ' file' + (e !== 1 ? 's' : '') + ')' : 'Exams';
                            labels.portfolio.textContent = po > 0 ? 'Portfolio (' + po + ' submission' + (po !== 1 ? 's' : '') + ')' : 'Portfolio';
                        }
                        sel.addEventListener('change', updateLabels);
                        updateLabels();
                    })();
                </script>
            </div>
        <?php else: ?>
            <div class="bg-white rounded-lg shadow-sm p-4 sm:p-6 mb-4 sm:mb-6">
                <h2 class="text-base sm:text-lg font-semibold text-gray-900 mb-2">Download Unit Documents</h2>
                <p class="text-sm text-gray-500">No units in your class for the active term.</p>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Progress by Class -->
    <?php if($classProgress->count() > 0): ?>
        <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Progress by Class</h2>
            <div class="space-y-4">
                <?php $__currentLoopData = $classProgress; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="border border-gray-200 rounded-lg p-4">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <h3 class="font-semibold text-gray-900"><?php echo e($classData['class']->name); ?></h3>
                                <?php if($classData['class']->code): ?>
                                    <p class="text-sm text-gray-500">Code: <?php echo e($classData['class']->code); ?></p>
                                <?php endif; ?>
                                <p class="text-xs text-gray-500 mt-1">
                                    <?php echo e($classData['class']->department->name); ?>

                                    <?php if($classData['class']->level): ?>
                                        • <?php echo e($classData['class']->level->name); ?>

                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-medium text-gray-700">Completion</p>
                                <p class="text-xl font-bold text-indigo-600"><?php echo e($classData['completion_percentage']); ?>%</p>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="w-full bg-gray-200 rounded-full h-2">
                                <div class="bg-indigo-600 h-2 rounded-full transition-all duration-300" style="width: <?php echo e($classData['completion_percentage']); ?>%"></div>
                            </div>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">
                                <?php echo e($classData['submitted_units']); ?> / <?php echo e($classData['total_units']); ?> units submitted
                            </span>
                            <span class="text-gray-600">
                                <?php echo e($classData['approved_units']); ?> approved
                            </span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- Recent Activity -->
    <?php if(isset($recentActivity) && $recentActivity->count() > 0): ?>
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Recent Activity</h2>
            <div class="space-y-3">
                <?php $__currentLoopData = $recentActivity; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center justify-between p-3 border border-gray-200 rounded-lg hover:bg-gray-50">
                        <div class="flex items-center space-x-3">
                            <div class="flex-shrink-0">
                                <svg class="h-8 w-8 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-900"><?php echo e($submission->unit->name); ?></p>
                                <p class="text-xs text-gray-500">
                                    <?php echo e($submission->schoolClass->name); ?>

                                    <?php if($submission->submitted_at): ?>
                                        • Submitted <?php echo e($submission->submitted_at->diffForHumans()); ?>

                                    <?php else: ?>
                                        • Created <?php echo e($submission->created_at->diffForHumans()); ?>

                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>
                        <div class="flex flex-wrap items-center gap-2">
                            <span class="px-2 py-1 text-xs font-semibold rounded-full <?php echo e($submission->getStatusBadgeClasses()); ?>">
                                <?php echo e($submission->getStatusLabel()); ?>

                            </span>
                            <a href="<?php echo e(route('student.submissions.show', $submission)); ?>" class="inline-flex items-center min-h-[44px] sm:min-h-0 text-indigo-600 hover:text-indigo-900 text-sm touch-manipulation">
                                View
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    <?php else: ?>
        <div class="bg-white rounded-lg shadow-sm p-12 text-center">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No activity yet</h3>
            <p class="mt-1 text-sm text-gray-500">Start by creating your first submission.</p>
            <div class="mt-6">
            <a href="<?php echo e(route('student.submissions.create')); ?>" class="inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 touch-manipulation">
                Create Submission
            </a>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/student/progress/index.blade.php ENDPATH**/ ?>